/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.block.DisplayTrophyBlock;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.entity.DisplayTrophyBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class DisplayTrophyRenderer
implements BlockEntityRenderer<DisplayTrophyBlockEntity> {
    public DisplayTrophyRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DisplayTrophyBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        stack.pushPose();
        stack.translate(0.5, (Boolean)entity.getBlockState().getValue((Property)TrophyBlock.PEDESTAL) != false ? 0.5 : 0.25, 0.5);
        stack.mulPose(Axis.YP.rotationDegrees(-((Direction)entity.getBlockState().getValue((Property)DisplayTrophyBlock.FACING)).getOpposite().toYRot()));
        DisplayTrophyRenderer.renderDisplay(entity.display.displayItem(), entity.display.scale(), entity.display.offset(), entity.display.rotation(), entity.display.rotationSpeed(), entity.display.bob(), (float)entity.ticker + partialTicks, stack, source, light, overlay);
        stack.popPose();
    }

    public static void renderDisplay(Item displayItem, float scale, Vec3 offset, Vec3 rotation, float rotationSpeed, boolean bob, float ticker, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        stack.pushPose();
        stack.translate(offset.x, offset.y, offset.z);
        stack.mulPose(Axis.YP.rotationDegrees(ticker * rotationSpeed));
        stack.mulPose(new Quaternionf().rotateXYZ((float)(rotation.x() * 0.01745329238474369), (float)(rotation.y() * 0.01745329238474369), (float)(rotation.z() * 0.01745329238474369)));
        if (bob) {
            stack.translate(0.0, (double)(Mth.sin((float)(ticker / 10.0f)) * 0.1f + 0.1f), 0.0);
        }
        stack.scale(0.4f, 0.4f, 0.4f);
        stack.scale(scale, scale, scale);
        Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)displayItem), ItemDisplayContext.NONE, light, overlay, stack, source, null, 0);
        stack.popPose();
    }
}

