/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.client.VariantToggleButton;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.Trophy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.CreativeModeTabSearchRegistry;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class CreativeModeVariantToggle {
    private static CreativeModeTab lastTab = CreativeModeTabs.getDefaultTab();
    private static String lastSearchQuery = "";
    public static VariantToggleButton showVariants;
    private static int guiCenterX;
    private static int guiCenterY;

    public static void setupButton() {
        NeoForge.EVENT_BUS.addListener(CreativeModeVariantToggle::addVariantButton);
        NeoForge.EVENT_BUS.addListener(CreativeModeVariantToggle::setupVariantButton);
    }

    private static void addVariantButton(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            guiCenterX = creativeScreen.getGuiLeft();
            guiCenterY = creativeScreen.getGuiTop();
            showVariants = new VariantToggleButton(guiCenterX + 174, guiCenterY + 3, (Component)Component.literal((String)"Show variants"), false, button -> {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof CreativeModeInventoryScreen) {
                    CreativeModeInventoryScreen creative = (CreativeModeInventoryScreen)screen;
                    CreativeModeVariantToggle.updateItems(creative);
                }
            });
            event.addListener((GuiEventListener)showVariants);
            CreativeModeVariantToggle.onSwitchCreativeTab(CreativeModeInventoryScreen.selectedTab, creativeScreen);
        }
    }

    private static void setupVariantButton(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            guiCenterX = creativeScreen.getGuiLeft();
            guiCenterY = creativeScreen.getGuiTop();
            CreativeModeTab tab = CreativeModeInventoryScreen.selectedTab;
            if (lastTab != tab) {
                CreativeModeVariantToggle.onSwitchCreativeTab(tab, creativeScreen);
                lastTab = tab;
            }
            if (tab == TrophyRegistries.TROPHY_TAB.get() && !creativeScreen.searchBox.getValue().equals(lastSearchQuery)) {
                tab.buildContents(CreativeModeVariantToggle.buildParams());
                lastSearchQuery = creativeScreen.searchBox.getValue();
            }
        }
    }

    private static void onSwitchCreativeTab(CreativeModeTab tab, CreativeModeInventoryScreen screen) {
        if (tab == TrophyRegistries.TROPHY_TAB.get()) {
            CreativeModeVariantToggle.showVariants.visible = true;
            CreativeModeVariantToggle.updateItems(screen);
        } else {
            CreativeModeVariantToggle.showVariants.visible = false;
        }
    }

    private static void updateItems(CreativeModeInventoryScreen screen) {
        CreativeModeTab.ItemDisplayParameters params = CreativeModeVariantToggle.buildParams();
        CreativeModeInventoryScreen.selectedTab.buildContents(params);
        CreativeModeInventoryScreen.ItemPickerMenu menu = (CreativeModeInventoryScreen.ItemPickerMenu)screen.getMenu();
        menu.items.clear();
        menu.items.addAll(CreativeModeVariantToggle.getTrophyList(Minecraft.getInstance().level.registryAccess(), params.enabledFeatures(), CreativeModeTabSearchRegistry.getNameSearchKey((CreativeModeTab)CreativeModeInventoryScreen.selectedTab), screen.searchBox.getValue()));
        menu.scrollTo(0.0f);
        screen.scrollOffs = 0.0f;
    }

    private static List<ItemStack> getTrophyList(RegistryAccess access, FeatureFlagSet set, @Nullable SessionSearchTrees.Key searchTree, String queriedSearch) {
        ArrayList<ItemStack> trophies = new ArrayList<ItemStack>();
        if (!Trophy.getTrophies().isEmpty()) {
            TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
            sortedTrophies.putAll(Trophy.getTrophies());
            for (Map.Entry trophyEntry : sortedTrophies.entrySet()) {
                if (!((Trophy)trophyEntry.getValue()).type().isEnabled(set)) continue;
                if (!((Trophy)trophyEntry.getValue()).getVariants((HolderLookup.Provider)access).isEmpty() && showVariants.isSelected()) {
                    ((Trophy)trophyEntry.getValue()).getVariants((HolderLookup.Provider)access).forEach(tag -> trophies.add(TrophyItem.loadVariantToTrophy(((Trophy)trophyEntry.getValue()).type(), tag)));
                    continue;
                }
                trophies.add(TrophyItem.loadEntityToTrophy(((Trophy)trophyEntry.getValue()).type()));
            }
        }
        return searchTree != null && !queriedSearch.isEmpty() ? Minecraft.getInstance().getConnection().searchTrees().creativeNameSearch(searchTree).search(queriedSearch) : trophies;
    }

    private static CreativeModeTab.ItemDisplayParameters buildParams() {
        FeatureFlagSet features = Optional.of(Minecraft.getInstance()).map(m -> m.player).map(p -> p.connection).map(ClientPacketListener::enabledFeatures).orElse(FeatureFlagSet.of());
        return new CreativeModeTab.ItemDisplayParameters(features, ((Boolean)Minecraft.getInstance().options.operatorItemsTab().get()).booleanValue(), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
    }

    static {
        guiCenterX = 0;
        guiCenterY = 0;
    }
}

