/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.gizmo.trophies.client.DisplayTrophyRenderer;
import com.gizmo.trophies.client.PlayerInfoHolder;
import com.gizmo.trophies.client.PlayerTrophyModel;
import com.gizmo.trophies.client.TrophyItemRenderer;
import com.gizmo.trophies.client.TrophyRenderer;
import com.gizmo.trophies.config.TrophyConfig;
import com.gizmo.trophies.misc.TrophyRegistries;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;

public class ClientEvents {
    private static final Map<String, Function<Component, Component>> SPECIAL_CASES = ImmutableMap.builder().put((Object)"celintro", name -> name.plainCopy().withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)" \u2620").withStyle(ChatFormatting.WHITE))).put((Object)"fastcheeta", name -> name.plainCopy().withStyle(ChatFormatting.DARK_PURPLE).append((Component)Component.literal((String)" \ud83c\udf3c").withStyle(ChatFormatting.LIGHT_PURPLE))).put((Object)"derpderpling", name -> name.plainCopy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)6560463)))).put((Object)"bigdious", name -> name.plainCopy().withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)" \u263a"))).put((Object)"melodioustwin", name -> name.plainCopy().withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)" \u266b"))).put((Object)"badneighbour", name -> name.plainCopy().withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)" \ud83d\ude97"))).put((Object)"jodlodi", name -> name.plainCopy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x992D22)))).put((Object)"benimatic", name -> name.plainCopy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)1146986)))).put((Object)"killer_demon", name -> name.plainCopy().withStyle(ChatFormatting.RED)).put((Object)"drullkus", name -> name.plainCopy().withStyle(ChatFormatting.GOLD)).put((Object)"tamaized", name -> name.plainCopy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16753898)))).put((Object)"alphaleaf", name -> name.plainCopy().withStyle(ChatFormatting.GREEN)).build();
    public static final ModelLayerLocation PLAYER_TROPHY = new ModelLayerLocation(OpenBlocksTrophies.prefix("player_trophy"), "main");
    public static final ModelLayerLocation SLIM_PLAYER_TROPHY = new ModelLayerLocation(OpenBlocksTrophies.prefix("slim_player_trophy"), "main");

    public static void init(IEventBus bus) {
        bus.addListener(EntityRenderersEvent.RegisterRenderers.class, event -> {
            event.registerBlockEntityRenderer((BlockEntityType)TrophyRegistries.TROPHY_BE.get(), TrophyRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)TrophyRegistries.DISPLAY_TROPHY_BE.get(), DisplayTrophyRenderer::new);
        });
        bus.addListener(EntityRenderersEvent.RegisterLayerDefinitions.class, event -> {
            event.registerLayerDefinition(PLAYER_TROPHY, () -> LayerDefinition.create((MeshDefinition)PlayerTrophyModel.createMesh(false), (int)64, (int)64));
            event.registerLayerDefinition(SLIM_PLAYER_TROPHY, () -> LayerDefinition.create((MeshDefinition)PlayerTrophyModel.createMesh(true), (int)64, (int)64));
        });
        NeoForge.EVENT_BUS.addListener(ClientEvents::dontRenderTrophyHitbox);
        bus.addListener(RegisterClientExtensionsEvent.class, event -> event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new TrophyItemRenderer();
            }
        }, new Item[]{(Item)TrophyRegistries.TROPHY_ITEM.get(), (Item)TrophyRegistries.DISPLAY_TROPHY_ITEM.get()}));
    }

    private static void dontRenderTrophyHitbox(RenderHighlightEvent.Block event) {
        BlockState state = event.getCamera().getEntity().level().getBlockState(event.getTarget().getBlockPos());
        if (state.is(TrophyRegistries.TROPHY)) {
            TrophyBlockEntity trophy;
            BlockEntity blockEntity;
            if (TrophyConfig.playersRenderNames && (blockEntity = event.getCamera().getEntity().level().getBlockEntity(event.getTarget().getBlockPos())) instanceof TrophyBlockEntity && (trophy = (TrophyBlockEntity)blockEntity).getTrophy() != null && trophy.getTrophy().type() == EntityType.PLAYER) {
                if (!trophy.getTrophyName().isBlank()) {
                    ClientEvents.renderNameTag((Component)Component.literal((String)trophy.getTrophyName()), event.getCamera(), event.getTarget().getBlockPos(), event.getPoseStack(), event.getMultiBufferSource(), (Boolean)state.getValue((Property)TrophyBlock.PEDESTAL));
                }
                event.setCanceled(true);
            }
            if (!((Boolean)state.getValue((Property)TrophyBlock.PEDESTAL)).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }

    private static void renderNameTag(Component name, Camera camera, BlockPos pos, PoseStack stack, MultiBufferSource source, boolean pedestal) {
        Vec3 vec = camera.getPosition();
        float f = (float)((double)pos.getX() - vec.x());
        float f1 = (float)((double)pos.getY() - vec.y());
        float f2 = (float)((double)pos.getZ() - vec.z());
        int i = name.getString().equalsIgnoreCase("deadmau5") ? -10 : 0;
        float offset = pedestal ? 1.25f : 1.0f;
        name = ClientEvents.handleSpecialNames(name);
        stack.pushPose();
        stack.translate(f + 0.5f, f1 + offset, f2 + 0.5f);
        stack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        stack.scale(-0.015f, -0.015f, 0.015f);
        Matrix4f matrix4f = stack.last().pose();
        float opacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(opacity * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float width = -font.width((FormattedText)name) / 2;
        font.drawInBatch(name, width, (float)i, 0x20FFFFFF, false, matrix4f, source, Font.DisplayMode.NORMAL, j, 0xF000F0);
        font.drawInBatch(name, width, (float)i, -1, false, matrix4f, source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        stack.popPose();
    }

    private static Component handleSpecialNames(Component name) {
        Component ogName = name;
        if (ogName.getString().equalsIgnoreCase("gizmothemoonpig")) {
            name = name.copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16724756))).append((Component)Component.literal((String)" \ud83d\udc51").withStyle(ChatFormatting.YELLOW));
        }
        if (ogName.getString().equalsIgnoreCase("tomatenjaeger")) {
            name = name.plainCopy().append((Component)Component.literal((String)" \u2764").withStyle(ChatFormatting.RED));
        }
        if (TrophyConfig.renderNameColorsAndIcons) {
            if (SPECIAL_CASES.containsKey(ogName.getString().toLowerCase())) {
                name = SPECIAL_CASES.get(ogName.getString().toLowerCase()).apply(name);
            }
            if (PlayerInfoHolder.TF_DEVS.contains(ogName.getString().toLowerCase(Locale.ROOT))) {
                name = name.copy().append((Component)Component.literal((String)"\ue115").withStyle(ChatFormatting.WHITE));
            }
            if (PlayerInfoHolder.MOJANGSTAS.contains(ogName.getString().toLowerCase(Locale.ROOT))) {
                name = name.copy().append((Component)Component.literal((String)"\uf56e").withStyle(ChatFormatting.DARK_RED));
            }
        }
        return name;
    }
}

