/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block.entity;

import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.Trophy;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrophyBlockEntity
extends BlockEntity {
    private int cooldown = 0;
    private CompoundTag variant = new CompoundTag();
    private Trophy trophy;
    private String trophyName = "";
    private boolean specialCycleVariant = false;

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TrophyRegistries.TROPHY_BE.get(), pos, state);
    }

    public static void tick(TrophyBlockEntity be) {
        if (be.cooldown > 0) {
            --be.cooldown;
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Nullable
    public Trophy getTrophy() {
        return this.trophy;
    }

    public void setTrophy(Trophy trophy) {
        this.trophy = trophy;
        this.setChanged();
        if (this.getLevel() != null) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getVariant() {
        return this.variant;
    }

    public void setVariant(@Nullable CompoundTag variant) {
        this.variant = variant;
    }

    public String getTrophyName() {
        return this.trophyName;
    }

    public void setTrophyName(String trophyName) {
        this.trophyName = trophyName;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.getTrophy() != null) {
            tag.putString("entity", Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey(this.getTrophy().type())).toString());
        }
        tag.putInt("cooldown", this.getCooldown());
        if (this.specialCycleVariant) {
            tag.putBoolean("SpecialCycleVariant", true);
        }
        if (!this.getVariant().isEmpty()) {
            tag.put("VariantID", (Tag)this.getVariant());
        }
        if (!this.getTrophyName().isEmpty()) {
            tag.putString("CustomNameEntity", this.getTrophyName());
        }
    }

    public boolean isCycling() {
        return this.specialCycleVariant;
    }

    public void setCycling(boolean cycling) {
        this.specialCycleVariant = cycling;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (Trophy.getTrophies().containsKey(ResourceLocation.tryParse((String)tag.getString("entity")))) {
            this.setTrophy(Trophy.getTrophies().get(ResourceLocation.tryParse((String)tag.getString("entity"))));
        }
        this.setCooldown(tag.getInt("cooldown"));
        if (tag.contains("SpecialCycleVariant")) {
            this.specialCycleVariant = tag.getBoolean("SpecialCycleVariant");
        }
        if (tag.contains("Variant")) {
            this.variant = tag.getCompound("VariantID");
        }
        if (tag.contains("CustomNameEntity")) {
            this.setTrophyName(tag.getString("CustomNameEntity"));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

