/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block.entity;

import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.DisplayTrophy;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DisplayTrophyBlockEntity
extends BlockEntity {
    public DisplayTrophy display = DisplayTrophy.FALLBACK;
    public int ticker;

    public DisplayTrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TrophyRegistries.DISPLAY_TROPHY_BE.get(), pos, state);
    }

    public static void tick(DisplayTrophyBlockEntity be) {
        ++be.ticker;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("display", (Tag)DisplayTrophy.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.display).getOrThrow());
        tag.putInt("tick", this.ticker);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.display = (DisplayTrophy)DisplayTrophy.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("display")).getOrThrow();
        this.ticker = tag.getInt("tick");
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(TrophyRegistries.DISPLAY_TROPHY_INFO, (Object)this.display);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.display = (DisplayTrophy)componentInput.getOrDefault(TrophyRegistries.DISPLAY_TROPHY_INFO, (Object)DisplayTrophy.FALLBACK);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("display");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

