/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block;

import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;

public record TrophyInfo(EntityType<?> type, Optional<CompoundTag> variant, Optional<Unit> cycling, Optional<Integer> cooldown) {
    public static final TrophyInfo DEFAULT = new TrophyInfo(EntityType.CHICKEN, Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<TrophyInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(TrophyInfo::type), (App)CompoundTag.CODEC.optionalFieldOf("variant").forGetter(TrophyInfo::variant), (App)Unit.CODEC.optionalFieldOf("cycling").forGetter(TrophyInfo::cycling), (App)Codec.INT.optionalFieldOf("cooldown").forGetter(TrophyInfo::cooldown)).apply((Applicative)instance, TrophyInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrophyInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), TrophyInfo::type, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)CompoundTag.CODEC)), TrophyInfo::variant, (StreamCodec)ByteBufCodecs.optional((StreamCodec)StreamCodec.unit((Object)Unit.INSTANCE)), TrophyInfo::cycling, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), TrophyInfo::cooldown, TrophyInfo::new);

    public TrophyInfo(EntityType<?> type) {
        this(type, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public TrophyInfo(EntityType<?> type, CompoundTag variant) {
        this(type, !variant.isEmpty() ? Optional.of(variant) : Optional.empty(), Optional.empty(), Optional.empty());
    }

    public TrophyInfo(EntityType<?> type, boolean cycling) {
        this(type, Optional.empty(), cycling ? Optional.of(Unit.INSTANCE) : Optional.empty(), Optional.empty());
    }

    public static TrophyInfo makeFromBlock(TrophyBlockEntity trophy) {
        if (trophy.getTrophy() != null) {
            Optional<Unit> cycling = trophy.isCycling() ? Optional.of(Unit.INSTANCE) : Optional.empty();
            Optional<Integer> cooldown = trophy.getCooldown() > 0 ? Optional.of(trophy.getCooldown()) : Optional.empty();
            return new TrophyInfo(trophy.getTrophy().type(), Optional.of(trophy.getVariant()), cycling, cooldown);
        }
        return DEFAULT;
    }
}

