/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block;

import com.gizmo.trophies.block.AbstractTrophyBlock;
import com.gizmo.trophies.block.TrophyInfo;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.gizmo.trophies.config.TrophyConfig;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.misc.AmbientSoundFetcher;
import com.gizmo.trophies.misc.TrophyRegistries;
import com.gizmo.trophies.trophy.Trophy;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrophyBlock
extends AbstractTrophyBlock {
    public static final MapCodec<TrophyBlock> CODEC = TrophyBlock.simpleCodec(TrophyBlock::new);
    private static final VoxelShape PLAYER_SHAPE = Block.box((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        TrophyBlockEntity trophy;
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof TrophyBlockEntity && (trophy = (TrophyBlockEntity)blockEntity).getTrophy() != null && trophy.getTrophy().type() == EntityType.PLAYER) {
            return (Boolean)state.getValue((Property)PEDESTAL) != false ? Shapes.or((VoxelShape)PEDESTAL_SHAPE, (VoxelShape)PLAYER_SHAPE) : NO_PEDESTAL_SHAPE;
        }
        return super.getShape(state, getter, pos, context);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBE = (TrophyBlockEntity)be;
            Trophy trophy = TrophyItem.getTrophy(stack);
            if (trophy != null) {
                trophyBE.setTrophy(trophy);
                trophyBE.setTrophyName(stack.has(DataComponents.CUSTOM_NAME) ? stack.getHoverName().getString() : "");
                TrophyInfo info = (TrophyInfo)stack.get(TrophyRegistries.TROPHY_INFO);
                if (info != null) {
                    if (info.variant().isPresent()) {
                        trophyBE.setVariant(info.variant().get());
                    }
                    if (info.cooldown().isPresent()) {
                        trophyBE.setCooldown(info.cooldown().get());
                    }
                    if (info.cooldown().isPresent()) {
                        trophyBE.setCycling(true);
                    }
                }
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        TrophyBlockEntity trophyBE;
        Trophy trophy;
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof TrophyBlockEntity && (trophy = (trophyBE = (TrophyBlockEntity)blockEntity).getTrophy()) != null) {
            if (trophy.type() == EntityType.PLAYER) {
                level.playSound(null, pos, (SoundEvent)TrophyRegistries.OOF.get(), SoundSource.BLOCKS, 1.0f, (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
            } else if (trophy.clickSoundOverride().isPresent()) {
                level.playSound(null, pos, trophy.clickSoundOverride().get(), SoundSource.BLOCKS, 1.0f, (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
            } else {
                Pair<SoundEvent, Float> soundData = AmbientSoundFetcher.getAmbientSoundAndPitch(trophy.type(), level);
                if (soundData.getFirst() != null) {
                    level.playSound(null, pos, (SoundEvent)soundData.getFirst(), SoundSource.BLOCKS, 1.0f, ((Float)soundData.getSecond()).floatValue());
                }
                if (trophyBE.getCooldown() <= 0 && trophy.clickBehavior().isPresent() && !TrophyConfig.rightClickEffectOverride) {
                    trophyBE.setCooldown(trophy.clickBehavior().get().execute(trophyBE, (ServerPlayer)player, player.getItemInHand(hand)));
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (player.isShiftKeyDown()) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)PEDESTAL));
            level.playSound(null, pos, SoundEvents.CANDLE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBE = (TrophyBlockEntity)blockEntity;
            ItemStack newStack = new ItemStack((ItemLike)this);
            newStack.set(TrophyRegistries.TROPHY_INFO, (Object)TrophyInfo.makeFromBlock(trophyBE));
            newStack.set(DataComponents.RARITY, (Object)TrophyItem.getTrophyRarity(newStack));
            drop.add(newStack);
        }
        return drop;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader reader, BlockPos pos, Player player) {
        ItemStack newStack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        if (blockEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBE = (TrophyBlockEntity)blockEntity;
            newStack.set(TrophyRegistries.TROPHY_INFO, (Object)TrophyInfo.makeFromBlock(trophyBE));
            if (!trophyBE.getTrophyName().isEmpty()) {
                newStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)trophyBE.getTrophyName()));
            }
            newStack.set(DataComponents.RARITY, (Object)TrophyItem.getTrophyRarity(newStack));
        }
        return newStack;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : TrophyBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TrophyRegistries.TROPHY_BE.get()), (level1, pos, state1, blockEntity) -> TrophyBlockEntity.tick(blockEntity));
    }
}

