/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block;

import com.gizmo.trophies.block.AbstractTrophyBlock;
import com.gizmo.trophies.block.entity.DisplayTrophyBlockEntity;
import com.gizmo.trophies.misc.TrophyRegistries;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class DisplayTrophyBlock
extends AbstractTrophyBlock {
    public static final MapCodec<DisplayTrophyBlock> CODEC = DisplayTrophyBlock.simpleCodec(DisplayTrophyBlock::new);

    public DisplayTrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof DisplayTrophyBlockEntity) {
            DisplayTrophyBlockEntity trophy = (DisplayTrophyBlockEntity)blockEntity;
            if (trophy.display.rightClickSound().isPresent()) {
                level.playSound(null, pos, trophy.display.rightClickSound().get(), SoundSource.BLOCKS, 1.0f, (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof DisplayTrophyBlockEntity) {
            DisplayTrophyBlockEntity trophy = (DisplayTrophyBlockEntity)blockEntity;
            ItemStack newStack = new ItemStack((ItemLike)this);
            newStack.set(TrophyRegistries.DISPLAY_TROPHY_INFO, (Object)trophy.display);
            newStack.set(DataComponents.RARITY, (Object)trophy.display.displayItem().getDefaultInstance().getRarity());
            drop.add(newStack);
        }
        return drop;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack newStack = new ItemStack((ItemLike)this);
        CompoundTag tag = new CompoundTag();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DisplayTrophyBlockEntity) {
            DisplayTrophyBlockEntity trophy = (DisplayTrophyBlockEntity)blockEntity;
            newStack.set(TrophyRegistries.DISPLAY_TROPHY_INFO, (Object)trophy.display);
            newStack.set(DataComponents.RARITY, (Object)trophy.display.displayItem().getDefaultInstance().getRarity());
        }
        return newStack;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DisplayTrophyBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide() ? null : DisplayTrophyBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TrophyRegistries.DISPLAY_TROPHY_BE.get()), (level1, pos, state1, blockEntity) -> DisplayTrophyBlockEntity.tick(blockEntity));
    }
}

