/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.AbstractTrophyBlock;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public record ShootProjectileBehavior(ItemStack projectile, int amount, boolean shootUpwards, Optional<SoundEvent> shootSound) implements CustomBehavior
{
    public static final MapCodec<ShootProjectileBehavior> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("projectile_item").validate(ShootProjectileBehavior::validate).forGetter(ShootProjectileBehavior::projectile), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(ShootProjectileBehavior::amount), (App)Codec.BOOL.fieldOf("shoot_upwards").forGetter(ShootProjectileBehavior::shootUpwards), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("shoot_sound").forGetter(ShootProjectileBehavior::shootSound)).apply((Applicative)instance, ShootProjectileBehavior::new));

    public ShootProjectileBehavior() {
        this(new ItemStack((ItemLike)Items.ARROW), 1, true, Optional.of(SoundEvents.ARROW_SHOOT));
    }

    private static DataResult<ItemStack> validate(ItemStack stack) {
        return stack.getItem() instanceof ProjectileItem ? DataResult.success((Object)stack) : DataResult.error(() -> "Item must implement the ProjectileItem interface");
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.PROJECTILE.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        BlockPos pos = block.getBlockPos();
        Level level = player.level();
        Direction shootDir = this.shootUpwards() ? Direction.UP : (Direction)block.getBlockState().getValue((Property)AbstractTrophyBlock.FACING);
        ProjectileItem item = (ProjectileItem)this.projectile().getItem();
        for (int i = 0; i < this.amount(); ++i) {
            Projectile projectile = item.asProjectile(level, (Position)Vec3.atCenterOf((Vec3i)pos), this.projectile(), shootDir);
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.setBaseDamage(0.1);
                arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            item.shoot(projectile, (double)shootDir.getStepX(), (double)shootDir.getStepY(), (double)shootDir.getStepZ(), 1.0f, 6.0f);
            if (this.shootSound().isPresent()) {
                level.playSound(null, player.blockPosition(), this.shootSound().get(), SoundSource.BLOCKS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + 0.5f);
            }
            level.addFreshEntity((Entity)projectile);
        }
        return 10 * this.amount();
    }
}

