/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record ShootLlamaSpitBehavior() implements CustomBehavior
{
    public static final MapCodec<ShootLlamaSpitBehavior> CODEC = MapCodec.unit(ShootLlamaSpitBehavior::new);

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.LLAMA_SPIT.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        BlockPos pos = block.getBlockPos();
        Level level = player.level();
        LlamaSpit spit = new LlamaSpit(EntityType.LLAMA_SPIT, level);
        spit.setPos((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)pos.getZ() + 0.5);
        double dX = player.getX() - (double)((float)pos.getX() + 0.5f);
        double dy = player.getBoundingBox().minY + player.getEyeY() / 3.0 - spit.getY();
        double dZ = player.getZ() - (double)((float)pos.getZ() + 0.5f);
        float f = Mth.sqrt((float)((float)(dX * dX + dZ * dZ))) * 0.2f;
        spit.shoot(dX, dy + (double)f, dZ, 1.5f, 10.0f);
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LLAMA_SPIT, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f);
        level.addFreshEntity((Entity)spit);
        return 10;
    }
}

