/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public record PullFromLootTableBehavior(ResourceKey<LootTable> lootTable, int rolls, int cooldown) implements CustomBehavior
{
    public static final MapCodec<PullFromLootTableBehavior> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(PullFromLootTableBehavior::lootTable), (App)Codec.INT.optionalFieldOf("rolls", (Object)1).forGetter(PullFromLootTableBehavior::rolls), (App)Codec.INT.optionalFieldOf("cooldown", (Object)1000).forGetter(PullFromLootTableBehavior::cooldown)).apply((Applicative)instance, PullFromLootTableBehavior::new));

    public PullFromLootTableBehavior(ResourceKey<LootTable> lootTable, int cooldown) {
        this(lootTable, 1, cooldown);
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.LOOT_TABLE.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        for (int i = 0; i < this.rolls(); ++i) {
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)player.level()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)block.getBlockPos())).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player.getLuck());
            player.serverLevel().getServer().reloadableRegistries().getLootTable(this.lootTable()).getRandomItems(builder.create(LootContextParamSets.ADVANCEMENT_REWARD)).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.copy()));
        }
        return this.cooldown();
    }
}

