/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public record PlaceBlockBehavior(BlockState placedBlock, PlacementMethod placement, int cooldown) implements CustomBehavior
{
    public static final MapCodec<PlaceBlockBehavior> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("block").forGetter(PlaceBlockBehavior::placedBlock), (App)PlacementMethod.CODEC.fieldOf("method").forGetter(PlaceBlockBehavior::placement), (App)Codec.INT.optionalFieldOf("cooldown", (Object)100).forGetter(PlaceBlockBehavior::cooldown)).apply((Applicative)instance, PlaceBlockBehavior::new));

    public PlaceBlockBehavior(Block block, PlacementMethod placement) {
        this(block.defaultBlockState(), placement, 100);
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.PLACE_BLOCK.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        BlockPos base = block.getBlockPos();
        Level level = block.getLevel();
        if (level != null) {
            switch (this.placement().ordinal()) {
                case 0: {
                    this.placeBlock(level, base.above());
                    break;
                }
                case 1: {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        this.placeBlock(level, base.relative(direction));
                    }
                    break;
                }
                case 2: {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            this.placeBlock(level, base.offset(x, 0, z));
                        }
                    }
                    break;
                }
                case 3: {
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -1; z <= 1; ++z) {
                                this.placeBlock(level, base.offset(x, y, z));
                            }
                        }
                    }
                    break;
                }
            }
        }
        return this.cooldown();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void placeBlock(Level level, BlockPos pos) {
        if (!level.getBlockState(pos).canBeReplaced()) return;
        if (!this.placedBlock().canSurvive((LevelReader)level, pos)) return;
        Block block = this.placedBlock().getBlock();
        if (block instanceof SnowLayerBlock) {
            SnowLayerBlock layer = (SnowLayerBlock)block;
            int layers = level.getRandom().nextInt(8) + 1;
            level.setBlockAndUpdate(pos, (BlockState)layer.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers)));
            return;
        }
        block = this.placedBlock().getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquid = (LiquidBlock)block;
            if (liquid.fluid.getFluidType().isVaporizedOnPlacement(level, pos, new FluidStack((Fluid)liquid.fluid, 1000))) {
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f);
                return;
            }
        }
        level.setBlockAndUpdate(pos, this.placedBlock());
    }

    public static enum PlacementMethod implements StringRepresentable
    {
        ABOVE,
        CROSS,
        AROUND,
        ENCASE;

        public static final StringRepresentable.EnumCodec<PlacementMethod> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(PlacementMethod::values);
        }
    }
}

