/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.behavior;

import com.gizmo.trophies.behavior.CustomBehavior;
import com.gizmo.trophies.behavior.CustomBehaviorType;
import com.gizmo.trophies.behavior.CustomTrophyBehaviors;
import com.gizmo.trophies.block.entity.TrophyBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record ClickWithItemBehavior(Either<ItemStack, TagKey<Item>> ingredient, boolean consumeStack, Optional<CustomBehavior> behavior, int cooldown, Optional<SoundEvent> sound) implements CustomBehavior
{
    public static final MapCodec<ClickWithItemBehavior> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)ItemStack.CODEC, (Codec)TagKey.codec((ResourceKey)Registries.ITEM)).fieldOf("item_to_use").forGetter(ClickWithItemBehavior::ingredient), (App)Codec.BOOL.fieldOf("shrink_item_stack").forGetter(ClickWithItemBehavior::consumeStack), (App)CustomBehaviorType.DISPATCH_CODEC.optionalFieldOf("execute_behavior").forGetter(ClickWithItemBehavior::behavior), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(ClickWithItemBehavior::cooldown), (App)SoundEvent.DIRECT_CODEC.optionalFieldOf("sound").forGetter(ClickWithItemBehavior::sound)).apply((Applicative)instance, ClickWithItemBehavior::new));

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior) {
        this(clickedItem, consumeStack, executeBehavior, 0, null);
    }

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, @Nullable SoundEvent sound) {
        this(clickedItem, consumeStack, executeBehavior, 0, sound);
    }

    public ClickWithItemBehavior(Item clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, int cooldown, @Nullable SoundEvent sound) {
        this((Either<ItemStack, TagKey<Item>>)Either.left((Object)new ItemStack((ItemLike)clickedItem)), consumeStack, Optional.ofNullable(executeBehavior), cooldown, Optional.ofNullable(sound));
    }

    public ClickWithItemBehavior(TagKey<Item> clickedItem, boolean consumeStack, @Nullable CustomBehavior executeBehavior, int cooldown, @Nullable SoundEvent sound) {
        this((Either<ItemStack, TagKey<Item>>)Either.right(clickedItem), consumeStack, Optional.ofNullable(executeBehavior), cooldown, Optional.ofNullable(sound));
    }

    @Override
    public CustomBehaviorType getType() {
        return (CustomBehaviorType)CustomTrophyBehaviors.CLICK_WITH_ITEM.get();
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player, ItemStack usedItem) {
        boolean valid = false;
        if (this.ingredient().left().isPresent() && ItemStack.isSameItem((ItemStack)usedItem, (ItemStack)((ItemStack)this.ingredient().left().get()))) {
            valid = true;
        } else if (this.ingredient().right().isPresent() && usedItem.is((TagKey)this.ingredient().right().get())) {
            valid = true;
        }
        if (valid) {
            if (this.behavior().isPresent()) {
                this.behavior().get().execute(block, player, usedItem);
            }
            if (this.consumeStack() && !player.isCreative()) {
                usedItem.shrink(1);
            }
            if (this.sound().isPresent()) {
                player.level().playSound(null, player.blockPosition(), this.sound().get(), SoundSource.BLOCKS, 1.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
            return this.cooldown();
        }
        return 0;
    }
}

