/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.HoldingPlayer.class})
public abstract class HoldingPlayerMixin
implements IHoldingPlayerExtension {
    @Unique
    private final ReentrantLock moonlight$concurrentLock = new ReentrantLock();
    @Unique
    private final Map<CustomMapData.Type<?, ?>, CustomMapData.DirtyCounter> moonlight$customDataDirty = new IdentityHashMap();
    @Unique
    private boolean moonlight$customMarkersDirty = true;
    @Unique
    private int moonlight$dirtyDecorationTicks = 0;
    @Unique
    private int moonlight$volatileDecorationRefreshTicks = 0;
    @Final
    @Shadow
    MapItemSavedData this$0;
    @Shadow
    @Final
    public Player player;
    @Shadow
    private boolean dirtyData;

    @Inject(method={"<init>(Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="TAIL")})
    public void initializeDirty(MapItemSavedData mapItemSavedData, Player player, CallbackInfo ci) {
        this.moonlight$customMarkersDirty = true;
        for (CustomMapData<?, ?> v : ((ExpandedMapData)mapItemSavedData).ml$getCustomData().values()) {
            this.moonlight$customDataDirty.put(v.getType(), (CustomMapData.DirtyCounter)v.createDirtyCounter());
        }
    }

    @Inject(method={"nextUpdatePacket(Lnet/minecraft/world/level/saveddata/maps/MapId;)Lnet/minecraft/network/protocol/Packet;"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkLocked(MapId mapId, CallbackInfoReturnable<@Nullable Packet<?>> cir) {
        if (this.moonlight$concurrentLock.isLocked()) {
            cir.setReturnValue(null);
        }
    }

    @ModifyReturnValue(method={"nextUpdatePacket(Lnet/minecraft/world/level/saveddata/maps/MapId;)Lnet/minecraft/network/protocol/Packet;"}, at={@At(value="TAIL")})
    public Packet<?> addExtraPacketData(@Nullable Packet<?> packet, MapId mapId) {
        MapItemSavedData data = this.this$0;
        ExpandedMapData ed = (ExpandedMapData)data;
        boolean updateData = false;
        boolean updateDeco = false;
        ArrayList dirtyData = new ArrayList();
        for (Map.Entry<CustomMapData.Type<?, ?>, CustomMapData.DirtyCounter> e : this.moonlight$customDataDirty.entrySet()) {
            CustomMapData.DirtyCounter dirtyCounter = e.getValue();
            if (!dirtyCounter.isDirty()) continue;
            dirtyData.add(e);
            updateData = true;
        }
        if (this.moonlight$customMarkersDirty && this.moonlight$dirtyDecorationTicks++ % 5 == 0) {
            this.moonlight$customMarkersDirty = false;
            updateDeco = true;
        }
        ArrayList extra = new ArrayList();
        for (MLMapMarker mLMapMarker : MapDataInternal.getDynamicServer(this.player, mapId, data)) {
            Object d = mLMapMarker.createDecorationFromMarker(data);
            if (d == null) continue;
            extra.add(d);
        }
        if (!extra.isEmpty() || this.moonlight$volatileDecorationRefreshTicks++ % 80 == 0) {
            updateDeco = true;
        }
        if (updateData || updateDeco) {
            if (packet == null) {
                packet = new ClientboundMapItemDataPacket(mapId, this.this$0.scale, this.this$0.locked, Optional.empty(), Optional.empty());
            }
            IMapDataPacketExtension ep = (IMapDataPacketExtension)packet;
            if (updateData) {
                ArrayList arrayList = new ArrayList();
                for (Map.Entry entry : dirtyData) {
                    arrayList.add(HoldingPlayerMixin.ml$createDirtyDataPatch(ed, (CustomMapData.Type)entry.getKey(), (CustomMapData.DirtyCounter)entry.getValue()));
                    ((CustomMapData.DirtyCounter)entry.getValue()).clearDirty();
                }
                if (!dirtyData.isEmpty()) {
                    ep.moonlight$setDirtyCustomData(Optional.of(arrayList));
                }
            }
            if (updateDeco) {
                ArrayList<MLMapDecoration> arrayList = new ArrayList<MLMapDecoration>(ed.ml$getCustomDecorations().values());
                arrayList.addAll(extra);
                ep.moonlight$setCustomDecorations(Optional.of(arrayList));
            }
        }
        return packet;
    }

    @Unique
    private static <P, C extends CustomMapData.DirtyCounter, D extends CustomMapData<C, P>> CustomMapData.DirtyDataPatch<?, ?> ml$createDirtyDataPatch(ExpandedMapData ed, CustomMapData.Type<?, ?> type, CustomMapData.DirtyCounter dirtyCounter) {
        CustomMapData<?, ?> d = ed.ml$getCustomData().get(type);
        Object patch = d.createUpdatePatch(dirtyCounter);
        CustomMapData.Type<?, ?> t = type;
        return new CustomMapData.DirtyDataPatch(t, patch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <H extends CustomMapData.DirtyCounter> void moonlight$setCustomDataDirty(CustomMapData.Type<?, ?> type, Consumer<H> dirtySetter) {
        try {
            this.moonlight$concurrentLock.lock();
            CustomMapData.DirtyCounter t = this.moonlight$customDataDirty.get(type);
            dirtySetter.accept(t);
        }
        finally {
            this.moonlight$concurrentLock.unlock();
        }
    }

    @Override
    public void moonlight$setCustomMarkersDirty() {
        this.moonlight$customMarkersDirty = true;
    }

    @Inject(method={"markColorsDirty(II)V"}, at={@At(value="HEAD")})
    public void lockData(int x, int z, CallbackInfo ci) {
        this.moonlight$concurrentLock.lock();
    }

    @Inject(method={"markColorsDirty(II)V"}, at={@At(value="RETURN")})
    public void sanityCheck(int x, int z, CallbackInfo ci) {
        this.moonlight$concurrentLock.unlock();
    }
}

