/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.neoforge.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    private static final WeakHashMap<RegistryAccess, Map<Fluid, Holder<SoftFluid>>> FLUID_MAP = new WeakHashMap();
    private static final WeakHashMap<RegistryAccess, Map<Item, Holder<SoftFluid>>> ITEM_MAP = new WeakHashMap();

    public static Holder<SoftFluid> fromVanillaFluid(Fluid fluid, RegistryAccess registryAccess) {
        if (!FLUID_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static Holder<SoftFluid> fromVanillaItem(Item item, RegistryAccess registryAccess) {
        if (!ITEM_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return ITEM_MAP.get(registryAccess).get(item);
    }

    private static void populateSlaveMaps(RegistryAccess registryAccess) {
        Map fludiMap = FLUID_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        Map itemMap = ITEM_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        fludiMap.clear();
        itemMap.clear();
        for (Holder.Reference h : SoftFluidRegistry.get(registryAccess).holders().toList()) {
            SoftFluid s = (SoftFluid)h.value();
            if (!s.isEnabled()) continue;
            for (Holder eq : s.getEquivalentFluids()) {
                Fluid value = (Fluid)eq.value();
                if (value == Fluids.EMPTY) {
                    Moonlight.LOGGER.error("!!Invalid fluid for fluid. This is a bug! {}", (Object)h);
                    if (PlatHelper.isDev()) {
                        throw new AssertionError((Object)("Invalid fluid for fluid. This is a bug! " + String.valueOf(h)));
                    }
                }
                fludiMap.put(value, h);
            }
            s.getEquivalentFluids().forEach(f -> fludiMap.put((Fluid)f.value(), h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.POTION || !MLBuiltinSoftFluids.WATER.is((Holder<SoftFluid>)h)) {
                    if (i == Items.AIR) {
                        Moonlight.LOGGER.error("!!Invalid item for fluid. This is a bug! {}", (Object)h);
                        if (PlatHelper.isDev()) {
                            throw new AssertionError((Object)("Invalid item for fluid. This is a bug! " + String.valueOf(h)));
                        }
                    }
                    itemMap.put(i, h);
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidInternalImpl.init();
    }

    public static void postInitClient(RegistryAccess ra) {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        Registry<SoftFluid> reg = SoftFluidRegistry.get(ra);
        for (SoftFluid f : reg) {
            f.afterInit();
        }
        SoftFluidColors.refreshParticleColors();
    }

    public static void onDataSyncToPlayer(ServerPlayer player, boolean isJoined) {
        if (isJoined) {
            NetworkHelper.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer(RegistryAccess ra) {
        SoftFluidInternal.populateSlaveMaps(ra);
        SoftFluidInternal.registerExistingVanillaFluids(ra, FLUID_MAP.get(ra), ITEM_MAP.get(ra));
        for (SoftFluid f : SoftFluidRegistry.get(ra)) {
            f.afterInit();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(RegistryAccess ra, Map<Fluid, Holder<SoftFluid>> fluidMap, Map<Item, Holder<SoftFluid>> itemMap) {
        void var2_2;
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(ra, (Map<Fluid, Holder<SoftFluid>>)var1_1, (Map<Item, Holder<SoftFluid>>)var2_2);
    }
}

