/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AdditionalItemPlacementsAPI {
    private static final List<Consumer<Event>> LISTENERS = Collections.synchronizedList(new ArrayList());
    private static final Map<Item, AdditionalItemPlacement> PLACEMENTS = new HashMap<Item, AdditionalItemPlacement>();
    private static final Set<Block> ADDED_BLOCKS = new HashSet<Block>();

    public static void addRegistration(Consumer<Event> eventConsumer) {
        Moonlight.assertInitPhase();
        LISTENERS.add(eventConsumer);
    }

    @Nullable
    public static AdditionalItemPlacement getBehavior(Item item) {
        return ((IExtendedItem)item).moonlight$getAdditionalBehavior();
    }

    public static boolean hasBehavior(Item item) {
        return AdditionalItemPlacementsAPI.getBehavior(item) != null;
    }

    @ApiStatus.Internal
    public static void onReload(RegistryAccess registryAccess, Boolean aBoolean) {
        Map map = Item.BY_BLOCK;
        for (Block block : ADDED_BLOCKS) {
            map.remove(block);
            block.item = null;
        }
        ADDED_BLOCKS.clear();
        for (Consumer consumer : LISTENERS) {
            consumer.accept(PLACEMENTS::put);
        }
        for (Map.Entry entry : PLACEMENTS.entrySet()) {
            AdditionalItemPlacement placement = (AdditionalItemPlacement)entry.getValue();
            Item i = (Item)entry.getKey();
            Block b = placement.getPlacedBlock();
            if (i == null || b == null) continue;
            if (i != Items.AIR && b != Blocks.AIR) {
                ((IExtendedItem)i).moonlight$addAdditionalBehavior(placement);
                if (map.containsKey(b)) continue;
                map.put(b, i);
                b.item = null;
                ADDED_BLOCKS.add(b);
                continue;
            }
            throw new AssertionError((Object)("Attempted to register an Additional behavior for block " + String.valueOf(b) + " using with item " + String.valueOf(i)));
        }
    }

    public static interface Event {
        public void register(Item var1, AdditionalItemPlacement var2);

        default public void registerSimple(Item target, Block toPlace) {
            this.register(target, new AdditionalItemPlacement(toPlace));
        }
    }
}

