/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.texture_renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.TickableFrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class RenderedTexturesManager {
    private static final LoadingCache<ResourceLocation, FrameBufferBackedDynamicTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().removalListener(i -> RenderSystem.recordRenderCall(((FrameBufferBackedDynamicTexture)((Object)((Object)i.getValue())))::close)).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ResourceLocation, FrameBufferBackedDynamicTexture>(){

        public FrameBufferBackedDynamicTexture load(ResourceLocation key) {
            return null;
        }
    });

    public static void clearCache() {
        TEXTURE_CACHE.invalidateAll();
    }

    public static FrameBufferBackedDynamicTexture requestTexture(ResourceLocation id, int textureSize, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean updateEachFrame) {
        FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)id));
        if (texture == null) {
            texture = updateEachFrame ? new TickableFrameBufferBackedDynamicTexture(id, textureSize, textureDrawingFunction) : new FrameBufferBackedDynamicTexture(id, textureSize, textureDrawingFunction);
            TEXTURE_CACHE.put((Object)id, (Object)texture);
            RenderSystem.recordRenderCall(texture::initialize);
        }
        return texture;
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemStackTexture(ResourceLocation res, ItemStack stack, int size) {
        return RenderedTexturesManager.requestTexture(res, size, t -> RenderedTexturesManager.drawItem(t, stack), true);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(Item item, int size) {
        return RenderedTexturesManager.requestFlatItemTexture(item, size, null);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(Item item, int size, @Nullable Consumer<NativeImage> postProcessing) {
        ResourceLocation id = Moonlight.res(Utils.getID(item).toString().replace(":", "/") + "/" + size);
        return RenderedTexturesManager.requestFlatItemTexture(id, item, size, postProcessing, false);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(ResourceLocation id, Item item, int size, @Nullable Consumer<NativeImage> postProcessing) {
        return RenderedTexturesManager.requestFlatItemTexture(id, item, size, postProcessing, false);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(ResourceLocation id, Item item, int size, @Nullable Consumer<NativeImage> postProcessing, boolean updateEachFrame) {
        return RenderedTexturesManager.requestTexture(id, size, t -> {
            RenderedTexturesManager.drawItem(t, item.getDefaultInstance());
            if (postProcessing != null) {
                t.download();
                NativeImage img = t.getPixels();
                postProcessing.accept(img);
                t.upload();
            }
        }, updateEachFrame);
    }

    public static void drawItem(FrameBufferBackedDynamicTexture tex, ItemStack stack) {
        RenderedTexturesManager.drawAsInGUI(tex, s -> RenderUtil.getGuiDummy(s).renderFakeItem(stack, 0, 0));
    }

    public static void drawTexture(FrameBufferBackedDynamicTexture tex, ResourceLocation texture) {
        RenderedTexturesManager.drawAsInGUI(tex, s -> {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            Matrix4f matrix = s.last().pose();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix, 0.0f, 16.0f, 0.0f).setUv(0.0f, 0.0f);
            bufferBuilder.addVertex(matrix, 16.0f, 16.0f, 0.0f).setUv(1.0f, 0.0f);
            bufferBuilder.addVertex(matrix, 16.0f, 0.0f, 0.0f).setUv(1.0f, 1.0f);
            bufferBuilder.addVertex(matrix, 0.0f, 0.0f, 0.0f).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        });
    }

    public static void drawNormalized(FrameBufferBackedDynamicTexture tex, Consumer<PoseStack> drawFunction) {
        RenderedTexturesManager.drawAsInGUI(tex, s -> {
            float scale = 0.0625f;
            s.translate(8.0f, 8.0f, 0.0f);
            s.scale(scale, scale, 1.0f);
            drawFunction.accept((PoseStack)s);
        });
    }

    public static void drawAsInGUI(FrameBufferBackedDynamicTexture tex, Consumer<PoseStack> drawFunction) {
        Minecraft mc = Minecraft.getInstance();
        RenderTarget frameBuffer = tex.getFrameBuffer();
        frameBuffer.clear(Minecraft.ON_OSX);
        frameBuffer.bindWrite(true);
        int size = 16;
        RenderSystem.backupProjectionMatrix();
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)size, (float)size, 0.0f, -1000.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.set((Matrix4fc)new Matrix4f().identity());
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        drawFunction.accept(new PoseStack());
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        mc.getMainRenderTarget().bindWrite(true);
    }
}

