/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FlammableLiquidBlock;
import net.mehvahdjukaar.supplementaries.common.fluids.LumiseneFluid;
import net.mehvahdjukaar.supplementaries.common.items.LumiseneBottleItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.neoforge.ModFluidsImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;

public class ModFluids {
    public static final int LUMISENE_MAX_LAYERS = 16;
    public static final int LUMISENE_FAKE_LIGHT_EMISSION = 11;
    public static final Supplier<FiniteFluid> LUMISENE_FLUID;
    public static final Supplier<FlammableLiquidBlock> LUMISENE_BLOCK;
    public static final Supplier<BucketItem> LUMISENE_BUCKET;
    public static final Supplier<Item> LUMISENE_BOTTLE;
    public static final HolderReference<SoftFluid> LUMISENE_SOFT_FLUID;

    public static void init() {
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static BucketItem createLumiseneBucket() {
        return ModFluidsImpl.createLumiseneBucket();
    }

    public static <T extends Fluid> Supplier<T> registerFluid(String name, Supplier<T> fluidSupplier) {
        return RegHelper.register((ResourceLocation)Supplementaries.res(name), fluidSupplier, (ResourceKey)Registries.FLUID);
    }

    public static int getLumiseneFaceLight(BlockAndTintGetter level, BlockPos pos, Operation<Integer> original) {
        if (level.getFluidState(pos).is((Fluid)LUMISENE_FLUID.get())) {
            int minLight;
            int i = level.getBrightness(LightLayer.SKY, pos);
            int j = level.getBrightness(LightLayer.BLOCK, pos);
            if (j < (minLight = 11)) {
                j = minLight;
            }
            return i << 20 | j << 4;
        }
        return (Integer)original.call(new Object[]{level, pos});
    }

    static {
        LUMISENE_SOFT_FLUID = HolderReference.of((ResourceLocation)Supplementaries.res("lumisene"), (ResourceKey)SoftFluidRegistry.KEY);
        LUMISENE_FLUID = ModFluids.registerFluid("lumisene", LumiseneFluid::new);
        LUMISENE_BLOCK = RegHelper.registerBlock((ResourceLocation)Supplementaries.res("lumisene"), () -> new FlammableLiquidBlock(LUMISENE_FLUID, BlockBehaviour.Properties.of().replaceable().instabreak().noTerrainParticles().mapColor(DyeColor.ORANGE).pushReaction(PushReaction.DESTROY).liquid().noCollission().noLootTable().hasPostProcess((state, level, pos) -> true).sound(SoundType.EMPTY).strength(0.0f, 100.0f), 0));
        LUMISENE_BUCKET = RegHelper.registerItem((ResourceLocation)Supplementaries.res("lumisene_bucket"), ModFluids::createLumiseneBucket);
        LUMISENE_BOTTLE = RegHelper.registerItem((ResourceLocation)Supplementaries.res("lumisene_bottle"), () -> new LumiseneBottleItem(new Item.Properties().stacksTo(1).craftRemainder(Items.GLASS_BOTTLE).food(new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().effect(new MobEffectInstance(MobEffects.GLOWING, CommonConfigs.Functional.GLOWING_DURATION.get().intValue(), 0), 1.0f).effect(new MobEffectInstance(ModRegistry.FLAMMABLE.getHolder(), CommonConfigs.Functional.FLAMMABLE_DURATION.get().intValue(), 0), 1.0f).build())));
    }
}

