/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.flywheel;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.tiles.WindVaneBlockTile;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WindVaneInstance
extends BlockEntityInstance<WindVaneBlockTile>
implements DynamicInstance {
    private final TextureAtlasSprite texture = ModMaterials.WIND_VANE_MATERIAL.sprite();
    private final ModelData chicken;
    private final PoseStack stack = new PoseStack();

    public WindVaneInstance(MaterialManager materialManager, WindVaneBlockTile tile) {
        super(materialManager, (BlockEntity)tile);
        BlockPos p = this.getInstancePosition();
        this.stack.translate((float)p.getX(), (float)p.getY(), (float)p.getZ());
        this.stack.scale(0.9995f, 0.9995f, 0.9995f);
        this.stack.translate(2.5E-4, 2.5E-4, 2.5E-4);
        this.stack.translate(0.5, 0.5, 0.5);
        this.stack.scale(1.0f, -1.0f, -1.0f);
        this.chicken = this.makeCenterInstance().setTransform(this.stack);
    }

    public void beginFrame() {
        this.stack.pushPose();
        float yaw = ((WindVaneBlockTile)this.blockEntity).getYaw(AnimationTickHolder.getPartialTicks());
        this.stack.mulPose(Axis.YP.rotationDegrees(yaw));
        this.chicken.setTransform(this.stack);
        this.stack.popPose();
    }

    public void remove() {
        this.chicken.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.chicken});
    }

    private ModelData makeCenterInstance() {
        Material material = this.materialManager.defaultCutout().material(Materials.TRANSFORMED);
        return (ModelData)material.model((Object)("chicken_" + String.valueOf(((WindVaneBlockTile)this.blockEntity).getType())), this::makeModel).createInstance();
    }

    private ModelPart makeModel() {
        return ModelPart.builder((String)"chicken", (int)32, (int)32).sprite(this.texture).cuboid().textureOffset(0, -11).start(0.0f, -8.0f, -5.5f).size(0.0f, 11.0f, 11.0f).endCuboid().build();
    }
}

