/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.flywheel;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BellowsBlockTile;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class BellowsInstance
extends BlockEntityInstance<BellowsBlockTile>
implements DynamicInstance {
    private final TextureAtlasSprite texture = ModMaterials.BELLOWS_MATERIAL.sprite();
    private final ModelData center;
    private final ModelData top;
    private final ModelData bottom;
    private final ModelData leather;
    private final PoseStack stack;

    public BellowsInstance(MaterialManager materialManager, BellowsBlockTile tile) {
        super(materialManager, (BlockEntity)tile);
        Quaternionf rotation = this.getDirection().getRotation();
        this.stack = new PoseStack();
        BlockPos p = this.getInstancePosition();
        this.stack.translate((float)p.getX(), (float)p.getY(), (float)p.getZ());
        this.stack.scale(0.9995f, 0.9995f, 0.9995f);
        this.stack.translate(2.5E-4, 2.5E-4, 2.5E-4);
        this.stack.translate(0.5, 0.5, 0.5);
        this.stack.mulPose(rotation);
        this.stack.mulPose(RotHlpr.X90);
        this.center = this.makeCenterInstance().setTransform(this.stack);
        this.stack.translate(-0.5, -0.5, -0.5);
        this.leather = this.makeLeatherInstance().setTransform(this.stack);
        this.top = this.makeTopInstance().setTransform(this.stack);
        this.bottom = this.makeBottomInstance().setTransform(this.stack);
        this.stack.translate(0.5, 0.5, 0.5);
    }

    public void beginFrame() {
        float dh = ((BellowsBlockTile)this.blockEntity).getHeight(AnimationTickHolder.getPartialTicks());
        this.stack.pushPose();
        this.stack.translate(0.0, -0.8125 - (double)dh, 0.0);
        this.top.setTransform(this.stack);
        this.stack.popPose();
        this.stack.pushPose();
        this.stack.translate(0.0f, dh, 0.0f);
        this.bottom.setTransform(this.stack);
        this.stack.popPose();
        this.stack.pushPose();
        float j = 3.2f;
        this.stack.scale(1.0f, 1.0f + j * dh, 1.0f);
        this.leather.setTransform(this.stack);
        this.stack.popPose();
    }

    public void remove() {
        this.top.delete();
        this.leather.delete();
        this.center.delete();
        this.bottom.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.top, this.center, this.leather, this.bottom});
    }

    private ModelData makeTopInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("top_" + String.valueOf(((BellowsBlockTile)this.blockEntity).getType())), this::makeLidModel).createInstance();
    }

    private ModelData makeBottomInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("bottom_" + String.valueOf(((BellowsBlockTile)this.blockEntity).getType())), this::makeLidModel).createInstance();
    }

    private ModelData makeLeatherInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("leather_" + String.valueOf(((BellowsBlockTile)this.blockEntity).getType())), this::makeLeatherModel).createInstance();
    }

    private ModelData makeCenterInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("center_" + String.valueOf(((BellowsBlockTile)this.blockEntity).getType())), this::makeCenterModel).createInstance();
    }

    private ModelPart makeLeatherModel() {
        return ModelPart.builder((String)"bellows_leather", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 37).start(-7.0f, -5.0f, -7.0f).size(14.0f, 10.0f, 14.0f).endCuboid().build();
    }

    private ModelPart makeLidModel() {
        return ModelPart.builder((String)"bellows_lid", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(-8.0f, 5.0f, -8.0f).size(16.0f, 3.0f, 16.0f).endCuboid().build();
    }

    private ModelPart makeCenterModel() {
        return ModelPart.builder((String)"bellows_center", (int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(-2.0f, -2.0f, -8.0f).size(4.0f, 1.0f, 1.0f).endCuboid().cuboid().textureOffset(0, 2).start(-2.0f, 1.0f, -8.0f).size(4.0f, 1.0f, 1.0f).endCuboid().cuboid().textureOffset(0, 19).start(-8.0f, -1.0f, -8.0f).size(16.0f, 2.0f, 16.0f).endCuboid().build();
    }

    private Direction getDirection() {
        return (Direction)this.blockState.getValue((Property)BellowsBlock.FACING);
    }
}

