/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.items.components.PresentAddress;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class PresentRecipientAttribute
implements ItemAttribute {
    public static final PresentRecipientAttribute EMPTY = new PresentRecipientAttribute("@e");
    String recipient;

    public PresentRecipientAttribute(String recipient) {
        this.recipient = recipient;
    }

    public boolean appliesTo(ItemStack itemStack) {
        return this.readRecipient(itemStack).equals(this.recipient);
    }

    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        String name = this.readRecipient(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (name.length() > 0) {
            atts.add(new PresentRecipientAttribute(name));
        }
        return atts;
    }

    public String getTranslationKey() {
        return "present_recipient";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{this.recipient};
    }

    public void writeNBT(CompoundTag compoundTag) {
        compoundTag.putString("recipient", this.recipient);
    }

    public ItemAttribute readNBT(CompoundTag compoundTag) {
        return new PresentRecipientAttribute(compoundTag.getString("recipient"));
    }

    private String readRecipient(ItemStack itemStack) {
        PresentAddress address = (PresentAddress)itemStack.get(ModComponents.ADDRESS.get());
        if (address != null && address.isPublic()) {
            return address.recipient();
        }
        return "";
    }
}

