/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.VecHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CreateCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BambooSpikesBehavior
implements MovementBehaviour {
    private static final BambooSpikesBlockTile DUMMY = new BambooSpikesBlockTile(BlockPos.ZERO, ModRegistry.BAMBOO_SPIKES.get().defaultBlockState());

    public boolean isSameDir(MovementContext context) {
        return VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.getValue((Property)BambooSpikesBlock.FACING)));
    }

    public boolean renderAsNormalBlockEntity() {
        return true;
    }

    public void tick(MovementContext context) {
        this.damageEntities(context);
    }

    public void damageEntities(MovementContext context) {
        Level world = context.world;
        Vec3 pos = context.position;
        DamageSource damageSource = BambooSpikesBlock.getDamageSource(world);
        block0: for (Entity entity : world.getEntitiesOfClass(Entity.class, new AABB(pos.add(-0.5, -0.5, -0.5), pos.add(0.5, 0.5, 0.5)))) {
            Object player;
            if (entity instanceof ItemEntity || entity instanceof AbstractContraptionEntity || entity instanceof Player && (player = (Player)entity).isCreative()) continue;
            if (entity instanceof AbstractMinecart) {
                player = entity.getIndirectPassengers().iterator();
                while (player.hasNext()) {
                    Entity passenger = (Entity)player.next();
                    if (!CreateCompat.isContraption(context, passenger)) continue;
                    continue block0;
                }
            }
            if (entity.isAlive() && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!world.isClientSide) {
                    double pow = 5.0 * Math.pow(context.relativeMotion.length(), 0.4) + 1.0;
                    float damage = !this.isSameDir(context) ? 1.0f : (float)Mth.clamp((double)pow, (double)2.0, (double)6.0);
                    entity.hurt(damageSource, damage);
                    this.doTileStuff(context, world, livingEntity);
                }
            }
            if (world.isClientSide != entity instanceof Player) continue;
            Vec3 motionBoost = context.motion.add(0.0, context.motion.length() / 4.0, 0.0);
            int maxBoost = 4;
            if (motionBoost.length() > (double)maxBoost) {
                motionBoost = motionBoost.subtract(motionBoost.normalize().scale(motionBoost.length() - (double)maxBoost));
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(motionBoost));
            entity.hurtMarked = true;
        }
    }

    private void doTileStuff(MovementContext context, @NotNull Level world, LivingEntity le) {
        CompoundTag com = context.blockEntityData;
        if (com == null) {
            return;
        }
        long lastTicked = com.getLong("LastTicked");
        if (!this.isOnCooldown(world, lastTicked)) {
            DUMMY.loadWithComponents(com, (HolderLookup.Provider)world.registryAccess());
            if (DUMMY.interactWithEntity(le, world)) {
                CreateCompat.changeState(context, (BlockState)context.state.setValue((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
            }
            com = DUMMY.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            lastTicked = world.getGameTime();
            com.putLong("LastTicked", lastTicked);
            context.blockEntityData = com;
        }
    }

    public boolean isOnCooldown(Level world, long lastTicked) {
        return world.getGameTime() - lastTicked < 20L;
    }
}

