/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.common.items.crafting.SpecialRecipeDisplays;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    private static final ResourceLocation ID = Supplementaries.res("jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (!CompatHandler.REI && !CompatHandler.EMI) {
            SpecialRecipeDisplays.registerCraftingRecipes(r -> registry.addRecipes(RecipeTypes.CRAFTING, r));
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get(), (ISubtypeInterpreter)SpikesSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModRegistry.BUNTING.get(), (ISubtypeInterpreter)BuntingSubtypeInterpreter.INSTANCE);
    }

    public static enum SpikesSubtypeInterpreter implements ISubtypeInterpreter<ItemStack>
    {
        INSTANCE;


        public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
            return BambooSpikesTippedItem.getPotion(stack);
        }

        public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
            return BambooSpikesTippedItem.getPotion(stack).toString();
        }
    }

    public static enum BuntingSubtypeInterpreter implements ISubtypeInterpreter<ItemStack>
    {
        INSTANCE;


        public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
            return stack.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.WHITE);
        }

        public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
            return ((DyeColor)stack.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.WHITE)).toString();
        }
    }
}

