/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.BlockPlacerItem;
import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.utils.neoforge.ItemsUtilImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ItemsUtil {
    private static final Component UNKNOWN_CONTENTS = Component.translatable((String)"container.shulkerBox.unknownContents");

    @Nullable
    public static BlockState getPlacementState(BlockPlaceContext context, Block block) {
        return BlockPlacerItem.get().mimicGetPlacementState(context, block);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace) {
        return ItemsUtil.place(context, blockToPlace, null);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace, @Nullable SoundType placeSound) {
        return BlockPlacerItem.get().mimicPlace(context, blockToPlace, placeSound);
    }

    public static InteractionResult place(Item item, BlockPlaceContext pContext) {
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            return bi.place(pContext);
        }
        AdditionalItemPlacement placement = AdditionalItemPlacementsAPI.getBehavior((Item)item);
        if (placement != null) {
            return placement.overridePlace(pContext);
        }
        return InteractionResult.PASS;
    }

    public static void addStackToExisting(Player player, ItemStack stack, boolean avoidHands) {
        int j;
        Inventory inv = player.getInventory();
        boolean added = false;
        for (j = 0; j < inv.items.size(); ++j) {
            if (!inv.getItem(j).is(stack.getItem()) || !inv.add(j, stack)) continue;
            added = true;
            break;
        }
        if (avoidHands && !added) {
            for (j = 0; j < inv.items.size(); ++j) {
                if (!inv.getItem(j).isEmpty() || j == inv.selected || !inv.add(j, stack)) continue;
                added = true;
                break;
            }
        }
        if (!added && inv.add(stack)) {
            player.drop(stack, false);
        }
    }

    public static boolean tryInteractingWithContainerItem(ItemStack containerStack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean inSlot) {
        if (action != ClickAction.PRIMARY) {
            if (incoming.isEmpty()) {
                if (!inSlot) {
                    return ItemsUtil.extractFromContainerItemIntoSlot(player, containerStack, slot);
                }
            } else if (ItemsUtil.addToContainerItem(player, containerStack, incoming, slot, true, inSlot)) {
                return ItemsUtil.addToContainerItem(player, containerStack, incoming, slot, false, inSlot);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean addToContainerItem(Player player, ItemStack containerStack, ItemStack stack, Slot slot, boolean simulate, boolean inSlot) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.addToContainerItem(player, (ItemStack)var1_1, (ItemStack)var2_2, (Slot)var3_3, (boolean)var4_4, (boolean)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean extractFromContainerItemIntoSlot(Player player, ItemStack containerStack, Slot slot) {
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.extractFromContainerItemIntoSlot(player, (ItemStack)var1_1, (Slot)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static float getEncumbermentFromInventory(ItemStack stack, ServerPlayer player) {
        void var1_1;
        return ItemsUtilImpl.getEncumbermentFromInventory(stack, (ServerPlayer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IKeyLockable.KeyStatus getPlayerKeyStatus(Player player, String key) {
        void var1_1;
        return ItemsUtilImpl.getPlayerKeyStatus(player, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack tryExtractingItem(Level level, @Nullable Direction dir, BlockPos pos, @Nullable BlockEntity container) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.tryExtractingItem(level, (Direction)var1_1, (BlockPos)var2_2, (BlockEntity)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack tryAddingItem(ItemStack stack, Level level, Entity entity) {
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.tryAddingItem(stack, (Level)var1_1, (Entity)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack tryAddingItem(ItemStack stack, Level level, Direction direction, BlockPos pos, BlockState state, @Nullable BlockEntity tile) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemsUtilImpl.tryAddingItem(stack, (Level)var1_1, (Direction)var2_2, (BlockPos)var3_3, (BlockState)var4_4, (BlockEntity)var5_5);
    }

    public static void addShulkerLikeTooltips(ItemStack stack, List<Component> tooltip) {
        if (stack.has(DataComponents.CONTAINER_LOOT)) {
            tooltip.add(UNKNOWN_CONTENTS);
        }
        int i = 0;
        int j = 0;
        for (ItemStack itemStack : ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
            ++j;
            if (i > 4) continue;
            ++i;
            tooltip.add((Component)Component.translatable((String)"container.shulkerBox.itemCount", (Object[])new Object[]{itemStack.getHoverName(), itemStack.getCount()}));
        }
        if (j - i > 0) {
            tooltip.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).withStyle(ChatFormatting.ITALIC));
        }
    }
}

