/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.trading.MerchantOffers;

public class ClientBoundSyncTradesPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundSyncTradesPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("s2c_sync_trades"), ClientBoundSyncTradesPacket::new);
    public final int containerId;
    public final MerchantOffers offers;
    public final int villagerLevel;
    public final int villagerXp;
    public final boolean showProgress;
    public final boolean canRestock;

    public ClientBoundSyncTradesPacket(RegistryFriendlyByteBuf buf) {
        this.containerId = buf.readVarInt();
        this.offers = (MerchantOffers)MerchantOffers.STREAM_CODEC.decode((Object)buf);
        this.villagerLevel = buf.readVarInt();
        this.villagerXp = buf.readVarInt();
        this.showProgress = buf.readBoolean();
        this.canRestock = buf.readBoolean();
    }

    public ClientBoundSyncTradesPacket(int id, MerchantOffers offers, int level, int villagerXp, boolean showProgress, boolean canRestock) {
        this.containerId = id;
        this.offers = offers;
        this.villagerLevel = level;
        this.villagerXp = villagerXp;
        this.showProgress = showProgress;
        this.canRestock = canRestock;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.containerId);
        MerchantOffers.STREAM_CODEC.encode((Object)buf, (Object)this.offers);
        buf.writeVarInt(this.villagerLevel);
        buf.writeVarInt(this.villagerXp);
        buf.writeBoolean(this.showProgress);
        buf.writeBoolean(this.canRestock);
    }

    public void handle(Message.Context context) {
        ClientReceivers.handleSyncTradesPacket(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

