/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.HashSet;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataDefinedCatchableMob;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClientBoundSyncCapturedMobsPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundSyncCapturedMobsPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("s2c_sync_captured_mobs"), ClientBoundSyncCapturedMobsPacket::new);
    protected final Set<DataDefinedCatchableMob> mobSet;
    @Nullable
    protected final DataDefinedCatchableMob fish;

    public ClientBoundSyncCapturedMobsPacket(Set<DataDefinedCatchableMob> mobMap, @Nullable DataDefinedCatchableMob fish) {
        this.mobSet = mobMap;
        this.fish = fish;
    }

    public ClientBoundSyncCapturedMobsPacket(RegistryFriendlyByteBuf buf) {
        int size = buf.readVarInt();
        this.mobSet = new HashSet<DataDefinedCatchableMob>();
        for (int i = 0; i < size; ++i) {
            DataDefinedCatchableMob r = (DataDefinedCatchableMob)DataDefinedCatchableMob.STREAM_CODEC.decode((Object)buf);
            this.mobSet.add(r);
        }
        this.fish = buf.readBoolean() ? (DataDefinedCatchableMob)DataDefinedCatchableMob.STREAM_CODEC.decode((Object)buf) : null;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.mobSet.size());
        for (DataDefinedCatchableMob entry : this.mobSet) {
            DataDefinedCatchableMob.STREAM_CODEC.encode((Object)buf, (Object)entry);
        }
        if (this.fish != null) {
            buf.writeBoolean(true);
            DataDefinedCatchableMob.STREAM_CODEC.encode((Object)buf, (Object)this.fish);
        } else {
            buf.writeBoolean(false);
        }
    }

    public void handle(Message.Context context) {
        ClientReceivers.handleSyncCapturedMobs(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

