/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BuiltinAnimation;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataCapturedMobInstance;
import net.mehvahdjukaar.supplementaries.common.utils.BiggerStreamCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public final class DataDefinedCatchableMob
implements ICatchableMob {
    public static final Codec<DataDefinedCatchableMob> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.listOf().fieldOf("owners").forGetter(p -> p.owners), (App)Codec.FLOAT.fieldOf("width_increment").forGetter(p -> Float.valueOf(p.widthIncrement)), (App)Codec.FLOAT.fieldOf("height_increment").forGetter(p -> Float.valueOf(p.heightIncrement)), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(p -> p.lightLevel), (App)CaptureSettings.CODEC.optionalFieldOf("allowed_in").forGetter(p -> p.captureSettings), (App)Codec.INT.optionalFieldOf("fish_index", (Object)0).forGetter(p -> p.fishIndex), (App)BuiltinAnimation.Type.CODEC.optionalFieldOf("animation", (Object)BuiltinAnimation.Type.NONE).forGetter(b -> b.builtinAnimation), (App)TickMode.CODEC.optionalFieldOf("tick_mode", (Object)TickMode.NONE).forGetter(p -> p.tickMode), (App)SoftFluid.HOLDER_CODEC.optionalFieldOf("render_fluid").forGetter(p -> p.renderFluid), (App)LootParam.CODEC.optionalFieldOf("loot").forGetter(p -> p.loot)).apply((Applicative)instance, DataDefinedCatchableMob::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataDefinedCatchableMob> STREAM_CODEC = BiggerStreamCodecs.composite(ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), p -> p.owners, ByteBufCodecs.FLOAT, p -> Float.valueOf(p.widthIncrement), ByteBufCodecs.FLOAT, p -> Float.valueOf(p.heightIncrement), ByteBufCodecs.INT, p -> p.lightLevel, CaptureSettings.STREAM_CODEC.apply(ByteBufCodecs::optional), p -> p.captureSettings, ByteBufCodecs.INT, p -> p.fishIndex, BuiltinAnimation.Type.STREAM_CODEC, p -> p.builtinAnimation, TickMode.STREAM_CODEC, p -> p.tickMode, SoftFluid.STREAM_CODEC.apply(ByteBufCodecs::optional), p -> p.renderFluid, (r, w, h, l, s, f, a, t, sf) -> new DataDefinedCatchableMob((List<ResourceLocation>)r, w.floatValue(), h.floatValue(), (int)l, (Optional<CaptureSettings>)s, (int)f, (BuiltinAnimation.Type)((Object)a), (TickMode)((Object)t), (Optional<Holder<SoftFluid>>)sf, Optional.empty()));
    private final List<ResourceLocation> owners;
    final float widthIncrement;
    final float heightIncrement;
    final int lightLevel;
    final Optional<CaptureSettings> captureSettings;
    final int fishIndex;
    final BuiltinAnimation.Type builtinAnimation;
    final TickMode tickMode;
    final Optional<LootParam> loot;
    final Optional<Holder<SoftFluid>> renderFluid;

    private DataDefinedCatchableMob(List<ResourceLocation> owners, float widthIncrement, float heightIncrement, int lightLevel, Optional<CaptureSettings> captureSettings, int fishIndex, BuiltinAnimation.Type builtinAnimation, TickMode tickMode, Optional<Holder<SoftFluid>> forceFluidID, Optional<LootParam> loot) {
        this.widthIncrement = widthIncrement;
        this.heightIncrement = heightIncrement;
        this.lightLevel = lightLevel;
        this.captureSettings = captureSettings;
        this.fishIndex = fishIndex;
        this.builtinAnimation = builtinAnimation;
        this.renderFluid = forceFluidID;
        this.loot = loot;
        this.tickMode = tickMode;
        this.owners = owners;
    }

    List<ResourceLocation> getOwners() {
        return this.owners;
    }

    @Override
    public <T extends Entity> CapturedMobInstance<T> createCapturedMobInstance(T self, float containerWidth, float containerHeight) {
        return new DataCapturedMobInstance<T>(self, this);
    }

    @Override
    public boolean canBeCaughtWithItem(Entity entity, Item item, Player player) {
        return this.captureSettings.map(settings -> settings.canCapture(entity, item)).orElseGet(() -> ICatchableMob.super.canBeCaughtWithItem(entity, item, player));
    }

    @Override
    public int getLightLevel(Level world, BlockPos pos) {
        return this.lightLevel;
    }

    @Override
    public boolean shouldHover(Entity self, boolean waterlogged) {
        BuiltinAnimation.Type cat = this.builtinAnimation;
        if (cat.isLand()) {
            return false;
        }
        return cat.isFlying() || ICatchableMob.super.shouldHover(self, waterlogged);
    }

    @Override
    public Optional<Holder<SoftFluid>> getForceFluid() {
        return this.renderFluid;
    }

    @Override
    public int getFishTextureIndex() {
        return this.fishIndex;
    }

    @Override
    public float getHitBoxWidthIncrement(Entity entity) {
        return this.widthIncrement;
    }

    @Override
    public float getHitBoxHeightIncrement(Entity entity) {
        return this.heightIncrement;
    }

    static enum TickMode implements StringRepresentable
    {
        NONE,
        SERVER,
        CLIENT,
        BOTH;

        public static final Codec<TickMode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, TickMode> STREAM_CODEC;

        boolean isValid(Level level) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 2 -> level.isClientSide;
                case 1 -> {
                    if (!level.isClientSide) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> true;
            };
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(TickMode::values);
            STREAM_CODEC = Utils.enumStreamCodec(TickMode.class);
        }
    }

    protected record CaptureSettings(CatchMode jarMode, CatchMode cageMode) {
        private static final Codec<CaptureSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CatchMode.CODEC.fieldOf("jar").forGetter(CaptureSettings::jarMode), (App)CatchMode.CODEC.fieldOf("cage").forGetter(CaptureSettings::cageMode)).apply((Applicative)instance, CaptureSettings::new));
        private static final StreamCodec<FriendlyByteBuf, CaptureSettings> STREAM_CODEC = StreamCodec.composite(CatchMode.STREAM_CODEC, CaptureSettings::jarMode, CatchMode.STREAM_CODEC, CaptureSettings::cageMode, CaptureSettings::new);

        public boolean canCapture(Entity entity, Item item) {
            LivingEntity le;
            if (item instanceof JarItem) {
                LivingEntity le2;
                return this.jarMode.on && (!this.jarMode.onlyBaby || !(entity instanceof LivingEntity) || (le2 = (LivingEntity)entity).isBaby());
            }
            return this.cageMode.on && (!this.cageMode.onlyBaby || !(entity instanceof LivingEntity) || (le = (LivingEntity)entity).isBaby());
        }
    }

    protected record LootParam(ResourceKey<LootTable> tableId, float chance) {
        private static final Codec<LootParam> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.xmap(i -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)i), ResourceKey::location).fieldOf("loot_table").forGetter(LootParam::tableId), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(LootParam::chance)).apply((Applicative)instance, LootParam::new));

        public void tryDropping(ServerLevel serverLevel, BlockPos pos, Entity entity) {
            if (serverLevel.random.nextFloat() < this.chance) {
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(this.tableId);
                LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)serverLevel.getBlockState(pos)).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity);
                ObjectArrayList l = lootTable.getRandomItems(builder.create(LootContextParamSets.GIFT));
                for (ItemStack o : l) {
                    entity.spawnAtLocation(o);
                }
            }
        }
    }

    protected record CatchMode(boolean on, boolean onlyBaby) {
        private static final Codec<CatchMode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("allow").forGetter(CatchMode::on), (App)Codec.BOOL.optionalFieldOf("only_baby", (Object)false).forGetter(CatchMode::onlyBaby)).apply((Applicative)instance, CatchMode::new));
        private static final StreamCodec<FriendlyByteBuf, CatchMode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, CatchMode::on, (StreamCodec)ByteBufCodecs.BOOL, CatchMode::onlyBaby, CatchMode::new);
    }
}

