/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataDefinedCatchableMob;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncCapturedMobsPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturedMobHandler
extends SimpleJsonResourceReloadListener {
    private static final SidedInstance<CapturedMobHandler> INSTANCES = SidedInstance.of(CapturedMobHandler::new);
    private final Set<String> commandMobs = new HashSet<String>();
    private final Map<EntityType<?>, DataDefinedCatchableMob> customMobProperties = new IdentityHashMap();
    private final HolderLookup.Provider registryAccess;
    private DataDefinedCatchableMob moddedFishProperty;

    public static CapturedMobHandler getInstance(HolderLookup.Provider ra) {
        return (CapturedMobHandler)((Object)INSTANCES.get(ra));
    }

    public static CapturedMobHandler getInstance(@NotNull Level level) {
        Preconditions.checkNotNull((Object)level);
        return CapturedMobHandler.getInstance((HolderLookup.Provider)level.registryAccess());
    }

    public CapturedMobHandler(HolderLookup.Provider ra) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "catchable_mobs_properties");
        this.registryAccess = ra;
        INSTANCES.set(ra, (Object)this);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.customMobProperties.clear();
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registryAccess);
        ArrayList list = new ArrayList();
        jsons.forEach((key, json) -> {
            DataDefinedCatchableMob data = (DataDefinedCatchableMob)DataDefinedCatchableMob.CODEC.parse((DynamicOps)ops, json).getOrThrow();
            if (key.getPath().equals("generic_fish")) {
                this.moddedFishProperty = data;
            } else {
                list.add(data);
            }
        });
        for (DataDefinedCatchableMob c : list) {
            for (ResourceLocation o : c.getOwners()) {
                BuiltInRegistries.ENTITY_TYPE.getOptional(o).ifPresent(e -> this.customMobProperties.put((EntityType<?>)e, c));
            }
        }
        if (this.moddedFishProperty == null) {
            Supplementaries.LOGGER.error("Failed to find json for 'generic_fish'. How? Found jsons were : {}", jsons.keySet());
        }
    }

    public static void sendDataToClient(ServerPlayer player) {
        CapturedMobHandler serverInstance = CapturedMobHandler.getInstance(player.level());
        HashSet<DataDefinedCatchableMob> set = new HashSet<DataDefinedCatchableMob>(serverInstance.customMobProperties.values());
        NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBoundSyncCapturedMobsPacket(set, serverInstance.moddedFishProperty));
    }

    public void acceptData(Set<DataDefinedCatchableMob> list, @Nullable DataDefinedCatchableMob defaultFish) {
        if (defaultFish != null) {
            this.moddedFishProperty = defaultFish;
        }
        this.customMobProperties.clear();
        for (DataDefinedCatchableMob c : list) {
            for (ResourceLocation o : c.getOwners()) {
                BuiltInRegistries.ENTITY_TYPE.getOptional(o).ifPresent(e -> this.customMobProperties.put((EntityType<?>)e, c));
            }
        }
    }

    public ICatchableMob getDataCap(EntityType<?> type, boolean isFish) {
        DataDefinedCatchableMob c = this.customMobProperties.get(type);
        if (c == null && isFish) {
            return this.moddedFishProperty;
        }
        return c;
    }

    public ICatchableMob getCatchableMobCapOrDefault(Entity entity) {
        if (entity instanceof ICatchableMob) {
            ICatchableMob cap = (ICatchableMob)entity;
            return cap;
        }
        ICatchableMob forgeCap = SuppPlatformStuff.getForgeCap(entity, ICatchableMob.class);
        if (forgeCap != null) {
            return forgeCap;
        }
        ICatchableMob prop = this.getDataCap(entity.getType(), BucketHelper.isModdedFish(entity));
        if (prop != null) {
            return prop;
        }
        return ICatchableMob.DEFAULT;
    }

    public boolean isCommandMob(String entity) {
        return this.commandMobs.contains(entity);
    }

    public void addCommandMob(String name) {
        this.commandMobs.add(name);
    }
}

