/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableContainerContent<M extends Mut<?>>
implements TooltipComponent,
TooltipProvider {
    protected final NonNullList<ItemStack> stacks;
    protected final int selectedSlot;
    protected final int selectedItemCount;
    protected final boolean empty;

    public SelectableContainerContent(List<ItemStack> stacks, int selected) {
        this.stacks = NonNullList.withSize((int)stacks.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < stacks.size(); ++i) {
            this.stacks.set(i, (Object)stacks.get(i));
        }
        this.selectedSlot = selected;
        this.selectedItemCount = SelectableContainerContent.computeSelectedItemCount(stacks, selected);
        this.empty = stacks.stream().allMatch(ItemStack::isEmpty);
    }

    public abstract M toMutable();

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public int getSelectedItemCount() {
        return this.selectedItemCount;
    }

    public List<ItemStack> getContentCopy() {
        return this.stacks.stream().map(ItemStack::copy).toList();
    }

    @ApiStatus.Internal
    public List<ItemStack> getContentUnsafe() {
        return this.stacks;
    }

    public ItemStack getSelectedUnsafe() {
        return (ItemStack)this.stacks.get(this.selectedSlot);
    }

    public ItemStack getSelected() {
        return ((ItemStack)this.stacks.get(this.selectedSlot)).copy();
    }

    public Item getSelectedItem() {
        return ((ItemStack)this.stacks.get(this.selectedSlot)).getItem();
    }

    public int getSelectedCount() {
        return ((ItemStack)this.stacks.get(this.selectedSlot)).getCount();
    }

    public ItemStack getStackInSlot(int slot) {
        SelectableContainerContent.validateSlotIndex(slot, this.stacks);
        return ((ItemStack)this.stacks.get(slot)).copy();
    }

    public int getSize() {
        return this.stacks.size();
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        if (this.selectedItemCount != 0) {
            tooltipAdder.accept((Component)Component.translatable((String)"message.supplementaries.quiver.tooltip", (Object[])new Object[]{this.getSelectedItem().getDescription(), this.selectedItemCount}).withStyle(ChatFormatting.GRAY));
        }
    }

    private static int computeSelectedItemCount(List<ItemStack> stacks, int sel) {
        ItemStack selected = stacks.get(sel);
        int amount = 0;
        for (ItemStack item : stacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)selected, (ItemStack)item)) continue;
            amount += item.getCount();
        }
        return amount;
    }

    protected static void validateSlotIndex(int slot, List<?> list) {
        if (slot < 0 || slot >= list.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + list.size() + ")");
        }
    }

    public int getBarSize() {
        return Math.min(1 + 12 * this.selectedItemCount / (((ItemStack)this.stacks.get(this.selectedSlot)).getMaxStackSize() * this.getSize()), 13);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectableContainerContent that = (SelectableContainerContent)o;
        return this.selectedSlot == that.selectedSlot && this.selectedItemCount == that.selectedItemCount && Objects.equals(this.stacks, that.stacks);
    }

    public int hashCode() {
        return Objects.hash(this.stacks, this.selectedSlot);
    }

    public static abstract class Mut<T extends SelectableContainerContent<?>> {
        protected NonNullList<ItemStack> stacks;
        protected int selectedSlot;

        protected Mut(SelectableContainerContent<?> original) {
            this.stacks = NonNullList.withSize((int)original.stacks.size(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < original.stacks.size(); ++i) {
                this.stacks.set(i, (Object)((ItemStack)original.stacks.get(i)).copy());
            }
            this.selectedSlot = original.selectedSlot;
        }

        public abstract T toImmutable();

        public void setStackInSlot(int slot, ItemStack stack) {
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            this.stacks.set(slot, (Object)stack);
        }

        public ItemStack getStackInSlot(int slot) {
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            return (ItemStack)this.stacks.get(slot);
        }

        public ItemStack getSelected() {
            return (ItemStack)this.stacks.get(this.selectedSlot);
        }

        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public int getSlots() {
            return this.stacks.size();
        }

        protected void updateSelectedIfNeeded() {
            this.cycle(0);
        }

        public boolean setSelectedSlot(int selectedSlot) {
            SelectableContainerContent.validateSlotIndex(selectedSlot, this.stacks);
            if (!((ItemStack)this.stacks.get(selectedSlot)).isEmpty()) {
                this.selectedSlot = selectedSlot;
                return true;
            }
            return false;
        }

        public int getSelectedSlot() {
            return this.selectedSlot;
        }

        @Nullable
        public ItemStack tryRemovingOne() {
            int i = 0;
            for (ItemStack s : this.stacks) {
                if (!s.isEmpty()) {
                    ItemStack extracted = this.extractItem(i, s.getCount(), false);
                    this.updateSelectedIfNeeded();
                    return extracted;
                }
                ++i;
            }
            return null;
        }

        public boolean isItemValid(ItemStack stack) {
            return this.isItemValid(0, stack);
        }

        public abstract boolean isItemValid(int var1, ItemStack var2);

        public ItemStack tryAdding(ItemStack toInsert, boolean onlyOnExisting) {
            if (toInsert.isEmpty()) {
                return toInsert;
            }
            if (onlyOnExisting) {
                int finalCount = toInsert.getCount();
                for (int i = 0; i < this.getSlots() && finalCount > 0; ++i) {
                    ItemStack s = this.getStackInSlot(i);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)toInsert)) continue;
                    int newCount = Math.min(s.getMaxStackSize(), s.getCount() + finalCount);
                    int increment = newCount - s.getCount();
                    finalCount -= increment;
                    s.grow(increment);
                }
                toInsert.setCount(finalCount);
            } else {
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (!(toInsert = this.insertItem(i, toInsert, false)).isEmpty()) continue;
                    return ItemStack.EMPTY;
                }
            }
            return toInsert;
        }

        public ItemStack tryAdding(ItemStack pInsertedStack) {
            return this.tryAdding(pInsertedStack, false);
        }

        public boolean cycle() {
            return this.cycle(1);
        }

        public boolean cycle(boolean clockWise) {
            return this.cycle(clockWise ? 1 : -1);
        }

        public boolean cycle(int slotsMoved) {
            ItemStack selected;
            int originalSlot = this.selectedSlot;
            if (slotsMoved == 0 && !(selected = (ItemStack)this.stacks.get(this.selectedSlot)).isEmpty()) {
                return false;
            }
            int maxSlots = this.stacks.size();
            this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved %= maxSlots))) % maxSlots;
            for (int i = 0; i < maxSlots && (selected = (ItemStack)this.stacks.get(this.selectedSlot)).isEmpty(); ++i) {
                this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved >= 0 ? 1 : -1))) % maxSlots;
            }
            return originalSlot != this.selectedSlot;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            int limit = this.getStackLimit(slot, stack);
            if (!existing.isEmpty()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.getCount();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.getCount() > limit;
            if (!simulate) {
                if (existing.isEmpty()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack));
                } else {
                    existing.grow(reachedLimit ? limit : stack.getCount());
                }
            }
            return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 99;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.EMPTY;
            }
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            if (existing.isEmpty()) {
                return ItemStack.EMPTY;
            }
            int toExtract = Math.min(amount, existing.getMaxStackSize());
            if (existing.getCount() <= toExtract) {
                if (!simulate) {
                    this.stacks.set(slot, (Object)ItemStack.EMPTY);
                    return existing;
                }
                return existing.copy();
            }
            if (!simulate) {
                this.stacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            }
            return existing.copyWithCount(toExtract);
        }

        public void consumeSelected(int toDecrement) {
            int i = this.selectedSlot;
            while (i < this.selectedSlot + this.stacks.size()) {
                ItemStack s = (ItemStack)this.stacks.get(i);
                if (!s.isEmpty()) {
                    int decrement = Math.min(toDecrement, s.getCount());
                    s.shrink(decrement);
                    if (s.isEmpty()) {
                        this.setStackInSlot(i, ItemStack.EMPTY);
                    }
                    if ((toDecrement -= decrement) <= 0) {
                        return;
                    }
                }
                i = (i + 1) % this.stacks.size();
            }
            Supplementaries.error();
        }
    }
}

