/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.common.items.LunchBoxItem;
import net.mehvahdjukaar.supplementaries.common.items.components.SelectableContainerContent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class LunchBaskedContent
extends SelectableContainerContent<Mutable> {
    protected static final MutableComponent CLOSED_TOOLTIP = Component.translatable((String)"message.supplementaries.lunch_box.tooltip.closed");
    protected static final MutableComponent OPEN_TOOLTIP = Component.translatable((String)"message.supplementaries.lunch_box.tooltip.open");
    public static final Codec<LunchBaskedContent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("items").forGetter(SelectableContainerContent::getContentCopy), (App)Codec.INT.fieldOf("selected_slot").forGetter(SelectableContainerContent::getSelectedSlot), (App)Codec.BOOL.fieldOf("open").forGetter(LunchBaskedContent::canEatFrom)).apply((Applicative)instance, LunchBaskedContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LunchBaskedContent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, SelectableContainerContent::getContentCopy, (StreamCodec)ByteBufCodecs.INT, SelectableContainerContent::getSelectedSlot, (StreamCodec)ByteBufCodecs.BOOL, LunchBaskedContent::canEatFrom, LunchBaskedContent::new);
    private final boolean isOpen;

    LunchBaskedContent(List<ItemStack> stacks, int selectedSlot, boolean isOpen) {
        super(stacks, selectedSlot);
        this.isOpen = isOpen;
    }

    public static LunchBaskedContent empty(int count) {
        return new LunchBaskedContent((List<ItemStack>)NonNullList.withSize((int)count, (Object)ItemStack.EMPTY), 0, false);
    }

    @Override
    public Mutable toMutable() {
        return new Mutable(this);
    }

    public boolean canEatFrom() {
        return this.isOpen;
    }

    @Override
    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        super.addToTooltip(context, tooltipAdder, tooltipFlag);
        tooltipAdder.accept((Component)(this.isOpen ? OPEN_TOOLTIP : CLOSED_TOOLTIP));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LunchBaskedContent that = (LunchBaskedContent)o;
        return this.selectedSlot == that.selectedSlot && this.selectedItemCount == that.selectedItemCount && Objects.equals(this.stacks, that.stacks) && this.isOpen == that.isOpen;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stacks, this.selectedSlot, this.isOpen);
    }

    public static class Mutable
    extends SelectableContainerContent.Mut<LunchBaskedContent> {
        private boolean isOpen;

        public Mutable(LunchBaskedContent original) {
            super(original);
            this.isOpen = original.isOpen;
        }

        @Override
        public LunchBaskedContent toImmutable() {
            this.updateSelectedIfNeeded();
            return new LunchBaskedContent((List<ItemStack>)this.stacks, this.selectedSlot, this.isOpen);
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return LunchBoxItem.canAcceptItem(stack);
        }

        public void switchMode() {
            this.isOpen = !this.isOpen;
        }
    }
}

