/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEnchantments;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SlingshotItem
extends ProjectileWeaponItem
implements IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    public SlingshotItem(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        int useDuration;
        float power;
        Player player;
        ItemStack ammo;
        if (entity instanceof Player && !(ammo = (player = (Player)entity).getProjectile(stack)).isEmpty() && (double)(power = SlingshotItem.getPowerForTime(useDuration = this.getUseDuration(stack, entity) - timeCharged, stack, entity)) >= 0.085) {
            List projectiles = SlingshotItem.draw((ItemStack)stack, (ItemStack)ammo, (LivingEntity)player);
            boolean noGravity = EnchantmentHelper.has((ItemStack)stack, ModEnchantments.PROJECTILE_NO_GRAVITY.get());
            power *= (float)((CommonConfigs.Tools.SLINGSHOT_RANGE.get() + (noGravity ? 0.5 : 0.0)) * 1.1);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!projectiles.isEmpty()) {
                    this.shoot(serverLevel, (LivingEntity)player, player.getUsedItemHand(), stack, projectiles, power, 1.0f, false, null);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        return new SlingshotProjectileEntity(level, ammo, weapon, shooter);
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vector3f vector3f;
        if (target != null) {
            double d = target.getX() - shooter.getX();
            double e = target.getZ() - shooter.getZ();
            double f = Math.sqrt(d * d + e * e);
            double g = target.getY(0.3333333333333333) - projectile.getY() + f * (double)0.2f;
            vector3f = SlingshotItem.getProjectileShotVector(shooter, new Vec3(d, g, e), angle);
        } else {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec32 = shooter.getViewVector(1.0f);
            vector3f = vec32.toVector3f().rotate((Quaternionfc)quaternionf);
        }
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
        float pitch = SlingshotItem.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), ModSounds.SLINGSHOT_SHOOT.get(), shooter.getSoundSource(), 1.0f, pitch);
    }

    private static Vector3f getProjectileShotVector(LivingEntity shooter, Vec3 distance, float angle) {
        Vector3f vector3f = distance.toVector3f().normalize();
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f2.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f2.x, vector3f2.y, vector3f2.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f3.x, vector3f3.y, vector3f3.z);
    }

    private static float getShotPitch(RandomSource random, int index) {
        return index == 0 ? 1.0f : SlingshotItem.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, RandomSource random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public static float getPowerForTime(float charge, ItemStack stack, LivingEntity entity) {
        float f = charge / (float)SlingshotItem.getChargeDuration(stack, entity);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static int getChargeDuration(ItemStack stack, LivingEntity shooter) {
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)shooter, (float)CommonConfigs.Tools.SLINGSHOT_CHARGE.get().intValue()) / 20.0f;
        return Mth.floor((float)(f * 20.0f));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        boolean flag = this.getAllSupportedProjectiles().test(player.getProjectile(itemstack));
        if (!flag) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(hand);
        player.level().playSound(player, (Entity)player, this.getChargeSound(itemstack), SoundSource.PLAYERS, 1.0f, 1.0f * (1.0f / (world.random.nextFloat() * 0.3f + 0.9f)));
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public SoundEvent getChargeSound(ItemStack stack) {
        Pair pair = EnchantmentHelper.getHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.CROSSBOW_CHARGE_TIME);
        int i = pair == null ? 0 : (Integer)pair.getSecond();
        return switch (i) {
            case 0 -> ModSounds.SLINGSHOT_CHARGE_0.get();
            case 1 -> ModSounds.SLINGSHOT_CHARGE_1.get();
            case 2 -> ModSounds.SLINGSHOT_CHARGE_2.get();
            default -> ModSounds.SLINGSHOT_CHARGE_3.get();
        };
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return s -> {
            Item i = s.getItem();
            if (i instanceof ThrowablePotionItem) {
                return CommonConfigs.Tools.SLINGSHOT_POTIONS.get();
            }
            if (i instanceof BombItem) {
                return CommonConfigs.Tools.SLINGSHOT_BOMBS.get();
            }
            if (i instanceof SnowballItem) {
                return CommonConfigs.Tools.SLINGSHOT_SNOWBALL.get();
            }
            if (i instanceof EnderpearlItem) {
                return CommonConfigs.Tools.SLINGSHOT_ENDERPEARLS.get();
            }
            if (i instanceof FireChargeItem) {
                return CommonConfigs.Tools.SLINGSHOT_FIRECHARGE.get();
            }
            if (i instanceof DispensibleContainerItem && i.hasCraftingRemainingItem()) {
                return CommonConfigs.Tools.SLINGSHOT_BUCKETS.get();
            }
            if (s.is(ModTags.SLINGSHOT_DAMAGEABLE)) {
                return true;
            }
            return !(i instanceof DispensibleContainerItem) && !s.is(ModTags.SLINGSHOT_BLACKLIST) && i instanceof BlockItem || AdditionalItemPlacementsAPI.hasBehavior((Item)i) || InteractEventsHandler.hasBlockPlacementAssociated(i);
        };
    }

    public int getDefaultProjectileRange() {
        return 10;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            model.leftArm.yRot = MthUtils.wrapRad((float)(0.1f + model.head.yRot));
            model.leftArm.xRot = MthUtils.wrapRad((float)(-1.5707964f + model.head.xRot));
            return true;
        }
        return false;
    }

    public boolean isTwoHanded() {
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            model.rightArm.yRot = MthUtils.wrapRad((float)(-0.1f + model.head.yRot));
            model.rightArm.xRot = MthUtils.wrapRad((float)(-1.5707964f + model.head.xRot));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(Player entity, ItemStack stack, InteractionHand hand, HumanoidArm humanoidArm, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.isUsingItem() && entity.getUseItemRemainingTicks() > 0 && entity.getUsedItemHand() == hand) {
            float useDuration = (float)stack.getUseDuration((LivingEntity)entity) - ((float)entity.getUseItemRemainingTicks() - partialTicks + 1.0f);
            float power = SlingshotItem.getPowerForTime(useDuration, stack, (LivingEntity)entity);
            if (power > 0.1f) {
                float f15 = Mth.sin((float)((useDuration - 0.1f) * 1.3f));
                float f18 = power - 0.1f;
                float f20 = f15 * f18;
                matrixStack.translate(0.0f, f20 * 0.004f, 0.0f);
            }
            matrixStack.translate(0.0f, 0.0f, power * 0.04f);
            matrixStack.scale(1.0f, 1.0f, 1.0f + power * 0.2f);
        }
    }
}

