/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.supplementaries.client.hud.SelectableContainerItemHud;
import net.mehvahdjukaar.supplementaries.common.items.components.SelectableContainerContent;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class SelectableContainerItem<C extends SelectableContainerContent<M>, M extends SelectableContainerContent.Mut<C>>
extends Item {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public SelectableContainerItem(Item.Properties properties) {
        super(properties);
    }

    public abstract DataComponentType<C> getComponentType();

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack myStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.getItem();
        boolean didStuff = false;
        SelectableContainerContent c = (SelectableContainerContent)myStack.get(this.getComponentType());
        if (c == null) {
            return false;
        }
        Object mutable = c.toMutable();
        if (itemstack.isEmpty()) {
            ItemStack removed = ((SelectableContainerContent.Mut)mutable).tryRemovingOne();
            if (removed != null) {
                this.playRemoveOneSound((Entity)pPlayer);
                ItemStack remainder = pSlot.safeInsert(removed);
                ((SelectableContainerContent.Mut)mutable).tryAdding(remainder);
                didStuff = true;
            }
        } else if (itemstack.getItem().canFitInsideContainerItems()) {
            ItemStack taken = pSlot.safeTake(itemstack.getCount(), itemstack.getMaxStackSize(), pPlayer);
            ItemStack remaining = ((SelectableContainerContent.Mut)mutable).tryAdding(taken);
            if (!remaining.equals(taken)) {
                this.playInsertSound((Entity)pPlayer);
                didStuff = true;
            }
            pSlot.set(remaining);
        }
        if (didStuff) {
            myStack.set(this.getComponentType(), ((SelectableContainerContent.Mut)mutable).toImmutable());
        }
        return didStuff;
    }

    public boolean overrideOtherStackedOnMe(ItemStack myStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.allowModification(pPlayer)) {
            SelectableContainerContent c = (SelectableContainerContent)myStack.get(this.getComponentType());
            if (c == null) {
                return false;
            }
            Object data = c.toMutable();
            boolean didStuff = false;
            if (pOther.isEmpty()) {
                ItemStack removed = ((SelectableContainerContent.Mut)data).tryRemovingOne();
                if (removed != null) {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.set(removed);
                    didStuff = true;
                }
            } else {
                ItemStack i = ((SelectableContainerContent.Mut)data).tryAdding(pOther);
                if (!i.equals(pOther)) {
                    this.playInsertSound((Entity)pPlayer);
                    pAccess.set(i);
                    didStuff = true;
                }
            }
            if (didStuff) {
                myStack.set(this.getComponentType(), ((SelectableContainerContent.Mut)data).toImmutable());
            }
            return didStuff;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, InteractionHand hand) {
        ItemStack remaining;
        InteractionHand otherHand;
        ItemStack possibleArrowStack;
        ItemStack myStack = player.getItemInHand(hand);
        SelectableContainerContent data = (SelectableContainerContent)myStack.get(this.getComponentType());
        if (data == null) {
            return InteractionResultHolder.fail((Object)myStack);
        }
        Object mutable = data.toMutable();
        if (((SelectableContainerContent.Mut)mutable).isItemValid(possibleArrowStack = player.getItemInHand(otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)) && !(remaining = ((SelectableContainerContent.Mut)mutable).tryAdding(possibleArrowStack)).equals(possibleArrowStack)) {
            this.playInsertSound((Entity)player);
            player.setItemInHand(otherHand, remaining);
            myStack.set(this.getComponentType(), ((SelectableContainerContent.Mut)mutable).toImmutable());
            return InteractionResultHolder.sidedSuccess((Object)myStack, (boolean)pLevel.isClientSide);
        }
        if (player.isSecondaryUseActive()) {
            if (((SelectableContainerContent.Mut)mutable).cycle()) {
                this.playInsertSound((Entity)player);
            }
            myStack.set(this.getComponentType(), ((SelectableContainerContent.Mut)mutable).toImmutable());
            return InteractionResultHolder.sidedSuccess((Object)myStack, (boolean)pLevel.isClientSide);
        }
        if (pLevel.isClientSide) {
            SelectableContainerItemHud.INSTANCE.setUsingItem(SlotReference.hand(hand), (LivingEntity)player);
        }
        this.playRemoveOneSound((Entity)player);
        myStack.set(this.getComponentType(), ((SelectableContainerContent.Mut)mutable).toImmutable());
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)myStack);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (level.isClientSide) {
            SelectableContainerItemHud.INSTANCE.setUsingItem(SlotReference.EMPTY, livingEntity);
        }
        this.playInsertSound((Entity)livingEntity);
        livingEntity.swing(livingEntity.getUsedItemHand());
        super.releaseUsing(stack, level, livingEntity, timeCharged);
    }

    public boolean isBarVisible(ItemStack pStack) {
        SelectableContainerContent data = (SelectableContainerContent)pStack.get(this.getComponentType());
        if (data != null) {
            return data.getSelectedCount() > 0;
        }
        return false;
    }

    public int getBarWidth(ItemStack pStack) {
        SelectableContainerContent data = (SelectableContainerContent)pStack.get(this.getComponentType());
        if (data != null) {
            return data.getBarSize();
        }
        return 0;
    }

    public int getBarColor(ItemStack pStack) {
        return BAR_COLOR;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        SelectableContainerContent data = (SelectableContainerContent)pStack.get(this.getComponentType());
        if (data != null && !data.isEmpty()) {
            return Optional.of(data);
        }
        return Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        SelectableContainerContent data = (SelectableContainerContent)stack.get(this.getComponentType());
        if (data != null) {
            data.addToTooltip(context, tooltipComponents::add, tooltipFlag);
        }
    }

    public void onDestroyed(ItemEntity pItemEntity) {
        SelectableContainerContent data = (SelectableContainerContent)pItemEntity.getItem().get(this.getComponentType());
        if (data != null) {
            ItemUtils.onContainerDestroyed((ItemEntity)pItemEntity, data.getContentCopy());
        }
    }

    protected void playRemoveOneSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    protected void playInsertSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    protected void playDropContentsSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    public abstract int getMaxSlots();

    public boolean modify(ItemStack stack, Function<M, Boolean> consumer) {
        Object mutable;
        SelectableContainerContent data = (SelectableContainerContent)stack.get(this.getComponentType());
        if (data != null && consumer.apply(mutable = data.toMutable()).booleanValue()) {
            stack.set(this.getComponentType(), ((SelectableContainerContent.Mut)mutable).toImmutable());
            return true;
        }
        return false;
    }
}

