/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ConfettiPopperItem
extends Item {
    public ConfettiPopperItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, InteractionHand hand) {
        Vec3 pos = player.getEyePosition().add(player.getLookAngle().scale(0.2)).add(0.0, -0.25, 0.0);
        float oldRot = player.getXRot();
        player.setXRot((float)((double)oldRot - 20.0 * Math.cos(oldRot * ((float)Math.PI / 180))));
        ClientBoundParticlePacket packet = new ClientBoundParticlePacket(pos, ClientBoundParticlePacket.Kind.CONFETTI, null, player.getLookAngle());
        player.setXRot(oldRot);
        if (!level.isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)player, (CustomPacketPayload)packet);
            level.gameEvent((Entity)player, (Holder)GameEvent.EXPLODE, player.position());
        } else {
            ClientReceivers.spawnConfettiParticles(packet, level, level.random);
        }
        ItemStack heldItem = player.getItemInHand(hand);
        heldItem.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)heldItem, (boolean)level.isClientSide);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand usedHand) {
        if (entity.getType() == EntityType.CREEPER && entity instanceof Creeper) {
            Creeper c = (Creeper)entity;
            if (entity instanceof IPartyCreeper) {
                IPartyCreeper pc = (IPartyCreeper)entity;
                if (!c.isIgnited() && !pc.supplementaries$isFestive()) {
                    pc.supplementaries$setFestive(true);
                    stack.consume(1, (LivingEntity)player);
                    return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
                }
            }
        }
        return super.interactLivingEntity(stack, player, entity, usedHand);
    }
}

