/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBuntingBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BuntingItem
extends Item {
    public BuntingItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!MiscUtils.showsHints(tooltipFlag)) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.bunting").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockHitResult hit;
        BlockState s;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (state.is((Block)ModRegistry.ROPE.get()) && (s = RopeBuntingBlock.fromRope(state, hit = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos, false))) != null) {
            level.setBlockAndUpdate(pos, s);
            ItemInteractionResult ret = s.useItemOn(context.getItemInHand(), level, context.getPlayer(), context.getHand(), hit);
            if (!ret.consumesAction()) {
                level.setBlockAndUpdate(pos, state);
            } else {
                return ret.result();
            }
        }
        return super.useOn(context);
    }

    public String getDescriptionId(ItemStack stack) {
        Object des = super.getDescriptionId(stack);
        des = (String)des + "_" + BuntingItem.getColor(stack).getName();
        return des;
    }

    public static DyeColor getColor(ItemStack item) {
        return (DyeColor)item.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.WHITE);
    }

    public static void setColor(ItemStack item, DyeColor color) {
        item.set(DataComponents.BASE_COLOR, (Object)color);
    }

    public static ItemStack getColored(DyeColor color) {
        ItemStack stack = new ItemStack((ItemLike)ModRegistry.BUNTING.get());
        BuntingItem.setColor(stack, color);
        return stack;
    }
}

