/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import org.jetbrains.annotations.NotNull;

public class BambooSpikesTippedItem
extends BlockItem
implements SimpleWaterloggedBlock {
    public BambooSpikesTippedItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltips, tooltipFlag);
        BambooSpikesTippedItem.getPotion(stack).addPotionTooltip(tooltips::add, 0.1f, context.tickRate());
    }

    public int getBarColor(ItemStack stack) {
        return BambooSpikesTippedItem.getPotion(stack).getColor();
    }

    public boolean isBarVisible(ItemStack stack) {
        return CommonConfigs.Functional.ONLY_ALLOW_HARMFUL.get() == false;
    }

    public String getDescriptionId(ItemStack stack) {
        PotionContents p = BambooSpikesTippedItem.getPotion(stack);
        return Potion.getName((Optional)p.potion(), (String)"item.supplementaries.bamboo_spikes_tipped.effect.");
    }

    public static boolean isPotionValid(PotionContents potion) {
        if (!potion.hasEffects()) {
            return false;
        }
        if (CommonConfigs.Functional.ONLY_ALLOW_HARMFUL.get().booleanValue()) {
            for (MobEffectInstance e : potion.getAllEffects()) {
                if (!((MobEffect)e.getEffect().value()).isBeneficial()) continue;
                return false;
            }
        }
        return potion.potion().isEmpty() || !((Holder)potion.potion().get()).is(ModTags.TIPPED_SPIKES_POTION_BLACKLIST);
    }

    @NotNull
    public static PotionContents getPotion(ItemStack stack) {
        return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    @NotNull
    public static PotionContents getPotion(SoftFluidStack stack) {
        return (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }
}

