/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.overrides;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.events.overrides.AntiqueInkBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.BlockUseBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ClockItemBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.CompassItemBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.FDStickBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseOnBlockBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.LightUpLumiseneLiquidBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.MapMarkerBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SoapBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ThrowableBricksBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ThrowableSlimeballBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.WrenchBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.WrittenBookHackBehavior;
import net.mehvahdjukaar.supplementaries.common.events.overrides.XPBottlingBehavior;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class InteractEventsHandler {
    private static final Map<Item, ItemUseOnBlockBehavior> ITEM_USE_ON_BLOCK_HP = new IdentityHashMap<Item, ItemUseOnBlockBehavior>();
    private static final Map<Item, ItemUseOnBlockBehavior> ITEM_USE_ON_BLOCK = new IdentityHashMap<Item, ItemUseOnBlockBehavior>();
    private static final Map<Item, ItemUseBehavior> ITEM_USE = new IdentityHashMap<Item, ItemUseBehavior>();
    private static final Map<Block, BlockUseBehavior> BLOCK_USE = new IdentityHashMap<Block, BlockUseBehavior>();

    public static boolean hasBlockPlacementAssociated(Item item) {
        ItemUseOnBlockBehavior v = ITEM_USE_ON_BLOCK.getOrDefault(item, ITEM_USE_ON_BLOCK_HP.get(item));
        return v != null && v.placesBlock();
    }

    public static void init() {
    }

    public static void setupOverrides() {
        ITEM_USE_ON_BLOCK.clear();
        ITEM_USE_ON_BLOCK_HP.clear();
        ITEM_USE.clear();
        BLOCK_USE.clear();
        ArrayList<ItemUseOnBlockBehavior> itemUseOnBlockHP = new ArrayList<ItemUseOnBlockBehavior>();
        ArrayList<ItemUseOnBlockBehavior> itemUseOnBlock = new ArrayList<ItemUseOnBlockBehavior>();
        ArrayList<ItemUseBehavior> itemUse = new ArrayList<ItemUseBehavior>();
        ArrayList<FDStickBehavior> blockUse = new ArrayList<FDStickBehavior>();
        blockUse.add(new FDStickBehavior());
        itemUse.add(new ThrowableBricksBehavior());
        itemUse.add(new ThrowableSlimeballBehavior());
        itemUse.add(new ClockItemBehavior());
        itemUse.add(new CompassItemBehavior());
        LightUpLumiseneLiquidBehavior liquidHack = new LightUpLumiseneLiquidBehavior();
        itemUse.add(liquidHack);
        itemUseOnBlock.add(liquidHack);
        itemUseOnBlockHP.add(new AntiqueInkBehavior());
        itemUseOnBlockHP.add(new SoapBehavior());
        itemUseOnBlockHP.add(new WrenchBehavior());
        itemUseOnBlock.add(new WrittenBookHackBehavior());
        itemUseOnBlock.add(new MapMarkerBehavior());
        itemUseOnBlock.add(new XPBottlingBehavior());
        block0: for (Item i : BuiltInRegistries.ITEM) {
            for (ItemUseOnBlockBehavior itemUseOnBlockBehavior : itemUseOnBlock) {
                if (!itemUseOnBlockBehavior.appliesToItem(i)) continue;
                ITEM_USE_ON_BLOCK.put(i, itemUseOnBlockBehavior);
            }
            for (ItemUseBehavior itemUseBehavior : itemUse) {
                if (!itemUseBehavior.appliesToItem(i)) continue;
                ITEM_USE.put(i, itemUseBehavior);
                continue block0;
            }
            for (ItemUseOnBlockBehavior itemUseOnBlockBehavior : itemUseOnBlockHP) {
                if (!itemUseOnBlockBehavior.appliesToItem(i)) continue;
                ITEM_USE_ON_BLOCK_HP.put(i, itemUseOnBlockBehavior);
                continue block0;
            }
        }
        block4: for (Block block : BuiltInRegistries.BLOCK) {
            for (BlockUseBehavior blockUseBehavior : blockUse) {
                if (!blockUseBehavior.appliesToBlock(block)) continue;
                BLOCK_USE.put(block, blockUseBehavior);
                continue block4;
            }
        }
    }

    public static InteractionResult onItemUsedOnBlockHP(Player player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        ItemUseOnBlockBehavior override = ITEM_USE_ON_BLOCK_HP.get(item);
        if (override != null && override.isEnabled()) {
            if (CompatHandler.FLAN && override.altersWorld() && !FlanCompat.canPlace(player, hit.getBlockPos())) {
                return InteractionResult.PASS;
            }
            if (override.altersWorld() && !Utils.mayPerformBlockAction((Player)player, (BlockPos)hit.getBlockPos(), (ItemStack)stack)) {
                return InteractionResult.PASS;
            }
            return override.tryPerformingAction(level, player, hand, stack, hit);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onItemUsedOnBlock(Player player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        BlockState aboveState;
        BlockState state;
        BlockUseBehavior o;
        boolean canAlter;
        Item item = stack.getItem();
        ItemUseOnBlockBehavior override = ITEM_USE_ON_BLOCK.get(item);
        BlockPos pos = hit.getBlockPos();
        boolean bl = canAlter = Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack) && (!CompatHandler.FLAN || FlanCompat.canPlace(player, pos));
        if (override != null && override.isEnabled()) {
            if (override.altersWorld() && !canAlter) {
                return InteractionResult.PASS;
            }
            InteractionResult result = override.tryPerformingAction(level, player, hand, stack, hit);
            if (result != InteractionResult.PASS) {
                return result;
            }
        }
        if (!player.isShiftKeyDown() && (o = BLOCK_USE.get((state = level.getBlockState(pos)).getBlock())) != null && o.isEnabled()) {
            if (o.altersWorld() && !canAlter) {
                return InteractionResult.PASS;
            }
            return o.tryPerformingAction(state, pos, level, player, hand, stack, hit);
        }
        if (canAlter && (aboveState = level.getBlockState(pos.above())).getFluidState().is((Fluid)ModFluids.LUMISENE_FLUID.get())) {
            return aboveState.useItemOn(stack, level, player, hand, new BlockHitResult(hit.getLocation(), hit.getDirection(), pos.above(), false)).result();
        }
        return InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> onItemUse(Player player, Level level, InteractionHand hand, ItemStack stack) {
        Item item = stack.getItem();
        ItemUseBehavior override = ITEM_USE.get(item);
        if (override != null && override.isEnabled()) {
            InteractionResult ret = override.tryPerformingAction(level, player, hand, stack, null);
            return switch (ret) {
                case InteractionResult.CONSUME -> InteractionResultHolder.consume((Object)stack);
                case InteractionResult.SUCCESS -> InteractionResultHolder.success((Object)stack);
                case InteractionResult.FAIL -> InteractionResultHolder.fail((Object)stack);
                default -> InteractionResultHolder.pass((Object)stack);
            };
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static void addOverrideTooltips(ItemStack itemStack, TooltipFlag tooltipFlag, List<Component> components) {
        Item item = itemStack.getItem();
        ItemUseOnBlockBehavior override = ITEM_USE_ON_BLOCK.get(item);
        if (override != null && override.isEnabled()) {
            MutableComponent t = override.getTooltip();
            if (t != null) {
                components.add((Component)t.withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
            }
        } else {
            MutableComponent t;
            ItemUseBehavior o = ITEM_USE.get(item);
            if (o != null && o.isEnabled() && (t = o.getTooltip()) != null) {
                components.add((Component)t.withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    public static InteractionResult replaceSimilarBlock(Block blockOverride, Player player, ItemStack stack, BlockPos pos, Level level, BlockState replaced, @Nullable SoundType sound, Property<?> ... properties) {
        BlockState newState = blockOverride.defaultBlockState();
        for (Property<?> p : properties) {
            newState = BlockUtil.replaceProperty(replaced, newState, p);
        }
        if (newState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            FluidState fluidstate = level.getFluidState(pos);
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8));
        }
        if (!level.setBlock(pos, newState, 3)) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, stack);
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
        if (sound == null) {
            sound = newState.getSoundType();
        }
        level.playSound(player, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
        if (player == null || !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

