/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AshLayerBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimesManager;
import net.mehvahdjukaar.supplementaries.common.block.tiles.EndermanSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.ISlimeable;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EatFodderGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EvokerRedMerchantWololooSpellGoal;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.CandyItem;
import net.mehvahdjukaar.supplementaries.common.items.FluteItem;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.items.SoapItem;
import net.mehvahdjukaar.supplementaries.common.items.components.QuiverContent;
import net.mehvahdjukaar.supplementaries.common.items.crafting.WeatheredMapRecipe;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.MapLightHandler;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.utils.IQuiverPlayer;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.IEntityInterceptFakeLevel;
import net.mehvahdjukaar.supplementaries.common.worldgen.WaySignStructure;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class ServerEvents {
    private static final boolean FODDER_ENABLED = CommonConfigs.Functional.FODDER_ENABLED.get();

    public static void onFireConsume(IFireConsumeBlockEvent event) {
        if (event.getState().getBlock() instanceof IRopeConnection) {
            LevelAccessor level = event.getLevel();
            BlockPos pos = event.getPos();
            level.removeBlock(pos, false);
            if (BaseFireBlock.canBePlacedAt((Level)((Level)level), (BlockPos)pos, (Direction)Direction.DOWN)) {
                BlockState state = BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos);
                if (state.hasProperty((Property)FireBlock.AGE)) {
                    event.setFinalState((BlockState)state.setValue((Property)FireBlock.AGE, (Comparable)Integer.valueOf(8)));
                }
                level.scheduleTick(pos, Blocks.FIRE, 2 + ((Level)level).random.nextInt(1));
            }
        } else {
            AshLayerBlock.tryConvertToAsh(event);
        }
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isSpectator()) {
            return InteractEventsHandler.onItemUsedOnBlock(player, level, player.getItemInHand(hand), hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onRightClickBlockHP(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isSpectator()) {
            return InteractEventsHandler.onItemUsedOnBlockHP(player, level, player.getItemInHand(hand), hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> onUseItem(Player player, Level level, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isSpectator()) {
            return InteractEventsHandler.onItemUse(player, level, hand, stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        if (player instanceof ISlimeable) {
            ISlimeable s = (ISlimeable)player;
            s.supp$setSlimedTicks(s.supp$getSlimedTicks(), true);
        }
        VibeChecker.checkVibe(player);
    }

    public static InteractionResult onRightClickEntity(Player player, Level level, InteractionHand hand, Entity entity, @Nullable EntityHitResult entityHitResult) {
        InteractionResult res;
        AbstractMobContainerItem containerItem;
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof FluteItem ? FluteItem.interactWithPet(stack, player, entity, hand) : (item instanceof AbstractMobContainerItem ? !(containerItem = (AbstractMobContainerItem)item).isFull(stack) && (res = containerItem.doInteract(stack, player, entity, hand)).consumesAction() : item == ModRegistry.SOAP.get() && SoapItem.interactWithEntity(stack, player, entity, hand))) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onServerStopped() {
        if (PlatHelper.getPhysicalSide().isClient()) {
            CapturedMobCache.clear();
        } else {
            WeatheredMapRecipe.onWorldUnload();
            WaySignStructure.clearCache();
            EndermanSkullBlockTile.clearCache();
            ColoredMapHandler.clearIdCache();
        }
    }

    public static void onServerStart(MinecraftServer server) {
        FaucetBehaviorsManager.reloadWithLevel(server.overworld());
        IEntityInterceptFakeLevel.get((Level)server.overworld());
    }

    public static void onDataSyncToPlayer(ServerPlayer player, boolean joined) {
        CapturedMobHandler.sendDataToClient(player);
        GlobeData.sendDataToClient(player);
        HourglassTimesManager.sendDataToClient(player);
        MapLightHandler.sendDataToClient(player);
    }

    public static void onEntityLoad(Entity entity, ServerLevel serverLevel) {
        if (FODDER_ENABLED && entity instanceof Animal) {
            Animal animal = (Animal)entity;
            EntityType type = entity.getType();
            if (type.is(ModTags.EATS_FODDER)) {
                animal.goalSelector.addGoal(3, (Goal)new EatFodderGoal(animal, 1.0, 8, 2, 30));
            }
            return;
        }
        if (entity.getType() == EntityType.EVOKER) {
            ((Evoker)entity).goalSelector.addGoal(6, (Goal)new EvokerRedMerchantWololooSpellGoal((Evoker)entity));
        }
    }

    public static void serverPlayerTick(Player player) {
        CandyItem.checkSweetTooth(player);
        if (player instanceof IQuiverPlayer) {
            IQuiverPlayer q = (IQuiverPlayer)player;
            SlotReference oldSlot = q.supplementaries$getQuiverSlot();
            SlotReference newSlot = QuiverItem.findActiveQuiverSlot((LivingEntity)player);
            if (!oldSlot.get((LivingEntity)player).equals(newSlot.get((LivingEntity)player))) {
                q.supplementaries$setQuiverSlot(newSlot);
                NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new SyncEquippedQuiverPacket((Entity)player, q));
            }
        }
    }

    public static boolean onItemPickup(ItemEntity itemEntity, Player player) {
        ItemStack stack = itemEntity.getItem();
        if (!itemEntity.hasPickUpDelay() && CommonConfigs.Tools.QUIVER_PICKUP.get().booleanValue() && QuiverItem.canAcceptItem(stack) && (itemEntity.getOwner() == null || SuppPlatformStuff.getItemLifeSpawn(itemEntity) - itemEntity.getAge() <= 200 || itemEntity.getOwner().equals((Object)player))) {
            ItemStack old = stack.copy();
            if (ServerEvents.takeArrow((Entity)itemEntity, player, stack)) {
                SuppPlatformStuff.fireItemPickupPost(player, itemEntity, old);
                player.onItemPickup(itemEntity);
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)stack.getItem()), old.getCount() - stack.getCount());
                return true;
            }
        }
        return false;
    }

    public static boolean onArrowPickup(AbstractArrow arrow, Player player, Supplier<ItemStack> pickup) {
        if (CommonConfigs.Tools.QUIVER_PICKUP.get().booleanValue()) {
            ItemStack stack = pickup.get();
            Preconditions.checkNotNull((Object)stack, (Object)("Arrow pickup item was null! This is an issue from the mod that added this entity " + String.valueOf(arrow)));
            return ServerEvents.takeArrow((Entity)arrow, player, stack);
        }
        return false;
    }

    private static boolean takeArrow(Entity itemEntity, Player player, ItemStack toPickUp) {
        QuiverContent data;
        ItemStack quiverItem = QuiverItem.findActiveQuiver((LivingEntity)player);
        if (!quiverItem.isEmpty() && (data = (QuiverContent)quiverItem.get(ModComponents.QUIVER_CONTENT.get())) != null) {
            int newCount;
            QuiverContent.Mutable mutable = data.toMutable();
            ItemStack copy = toPickUp.copy();
            int count = copy.getCount();
            if (count != (newCount = mutable.tryAdding(copy, true).getCount())) {
                player.take(itemEntity, count);
                toPickUp.setCount(newCount);
                if (toPickUp.isEmpty()) {
                    itemEntity.discard();
                }
                quiverItem.set(ModComponents.QUIVER_CONTENT.get(), (Object)mutable.toImmutable());
                return true;
            }
        }
        return false;
    }
}

