/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.supplementaries.common.entities.trades.StarItemListing;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public record RocketItemListing(ItemCost emeralds, Optional<ItemCost> priceSecondary, int rockets, int maxTrades, int xp, float priceMult, int level) implements ModItemListing
{
    public static final MapCodec<RocketItemListing> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemCost.CODEC.fieldOf("price").forGetter(RocketItemListing::emeralds), (App)ItemCost.CODEC.optionalFieldOf("price_secondary").forGetter(RocketItemListing::priceSecondary), (App)Codec.INT.fieldOf("amount").forGetter(RocketItemListing::rockets), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(RocketItemListing::maxTrades), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("xp").forGetter(s -> Optional.of(s.xp)), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(RocketItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(RocketItemListing::level)).apply((Applicative)instance, RocketItemListing::createDefault));

    public static RocketItemListing createDefault(ItemCost price, Optional<ItemCost> price2, int rockets, int maxTrades, Optional<Integer> xp, float priceMult, int level) {
        return new RocketItemListing(price, price2, rockets, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)false, (int)level)), priceMult, level);
    }

    public MerchantOffer getOffer(Entity entity, RandomSource random) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, this.rockets);
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        int stars = 0;
        ArrayList<FireworkExplosion.Shape> usedShapes = new ArrayList<FireworkExplosion.Shape>();
        do {
            explosions.add(StarItemListing.createRandomFireworkStar(random, usedShapes));
        } while (random.nextFloat() < 0.42f && ++stars < 7);
        int flightDuration = random.nextInt(3) + 1;
        Fireworks fireworks = new Fireworks(flightDuration, explosions);
        itemstack.set(DataComponents.FIREWORKS, (Object)fireworks);
        return new MerchantOffer(this.emeralds, this.priceSecondary, itemstack, this.maxTrades, ModItemListing.defaultXp((boolean)true, (int)this.level), this.priceMult);
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    public int getLevel() {
        return this.level;
    }
}

