/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.SpriteCoordinateUnExpander;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.EnchantRedesignCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BookPileBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final BooksList booksVisuals = new BooksList();
    public static final ModelDataKey<BooksList> BOOKS_KEY = ModBlockProperties.BOOKS_KEY;
    private static final RandomSource rand = RandomSource.create();
    public static final List<String> DEFAULT_COLORS = List.of("brown", "orange", "yellow", "red", "green", "lime", "cyan", "blue", "purple");

    public BookPileBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(BlockPos pos, BlockState state, boolean horizontal) {
        super(ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BOOKS_KEY, (Object)this.booksVisuals);
    }

    private void displayRandomColoredBooks(int i, HolderLookup.Provider provider) {
        for (int j = 0; j < i; ++j) {
            int r = rand.nextInt(10);
            Item it = r < 2 ? Items.ENCHANTED_BOOK : (r < 3 ? Items.WRITABLE_BOOK : Items.BOOK);
            List<BookType> col = ((PlaceableBookManager)((Object)PlaceableBookManager.INSTANCES.get(provider))).getForItem(it.getDefaultInstance(), this.horizontal);
            this.booksVisuals.add(new VisualBook(it.getDefaultInstance(), this.worldPosition, j, col, null, (HolderLookup.Provider)this.level.registryAccess(), this.horizontal));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putFloat("EnchantPower", this.enchantPower);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.enchantPower = tag.getFloat("EnchantPower");
        if (this.level != null && this.level.isClientSide) {
            this.requestModelReload();
        }
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        int b = (int)this.getItems().stream().filter(i -> !i.isEmpty()).count();
        if (b != (Integer)this.getBlockState().getValue((Property)BookPileBlock.BOOKS) && b == 0) {
            if (this.lootTable == null) {
                this.level.removeBlock(this.worldPosition, false);
            } else {
                return;
            }
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            ItemStack itemStack = this.getItem(i2);
            if (itemStack.isEmpty()) continue;
            Item item = itemStack.getItem();
            this.enchantPower = CompatHandler.QUARK && CompatObjects.TOME.get() == item ? (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0 * 2.0) : (item == Items.ENCHANTED_BOOK ? (float)((double)this.enchantPower + CommonConfigs.Tweaks.ENCHANTED_BOOK_POWER.get() / 4.0) : (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0));
        }
    }

    public void updateTileOnInventoryChanged() {
        super.updateTileOnInventoryChanged();
    }

    private void consolidateBookPile() {
        boolean prevEmpty = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack it = this.getItem(i);
            if (it.isEmpty()) {
                prevEmpty = true;
                continue;
            }
            if (!prevEmpty) continue;
            this.getItems().set(i - 1, (Object)it);
            this.getItems().set(i, (Object)ItemStack.EMPTY);
        }
    }

    public void updateClientVisualsOnLoad() {
        this.booksVisuals.clear();
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.supplementaries.book_pile");
    }

    public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
        return false;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public boolean canOpen(Player player) {
        return false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return null;
    }

    public record BooksList(List<VisualBook> books) {
        public BooksList() {
            this(new ArrayList<VisualBook>());
        }

        public void add(VisualBook visualBook) {
            this.books.add(visualBook);
        }

        public void add(int i, VisualBook visualBook) {
            this.books.add(i, visualBook);
        }

        public void clear() {
            this.books.clear();
        }

        public boolean isEmpty() {
            return this.books.isEmpty();
        }

        public VisualBook get(int i) {
            return this.books.get(i);
        }

        public int size() {
            return this.books.size();
        }
    }

    public static class VisualBook {
        private final float yAngle;
        private final BookType type;
        private final ItemStack stack;

        public VisualBook(ItemStack bookStack, BlockPos pos, int index, List<BookType> colors, @Nullable BookType lastColor, HolderLookup.Provider provider, boolean isHorizontal) {
            PlaceableBookManager bookReg = (PlaceableBookManager)((Object)PlaceableBookManager.INSTANCES.get(provider));
            this.stack = bookStack;
            Random rand = new Random(pos.below(2).asLong());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            Item item = bookStack.getItem();
            this.yAngle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            if (item instanceof BookItem) {
                if (lastColor == null) {
                    if (colors.isEmpty()) {
                        Supplementaries.error();
                        this.type = bookReg.getByName(ResourceLocation.parse((String)"brown"));
                        return;
                    }
                    this.type = colors.get(rand.nextInt(colors.size()));
                } else {
                    List<BookType> c = colors.stream().filter(b -> b.looksGoodNextTo(lastColor)).toList();
                    if (c.isEmpty()) {
                        Supplementaries.error();
                        this.type = lastColor;
                    } else {
                        this.type = c.get(rand.nextInt(c.size()));
                    }
                }
                colors.remove(this.type);
            } else {
                List<BookType> possibleTypes = bookReg.getForItem(bookStack, isHorizontal);
                if (possibleTypes.isEmpty()) {
                    Supplementaries.error();
                    this.type = bookReg.getByName(ResourceLocation.parse((String)"brown"));
                    return;
                }
                this.type = possibleTypes.get(rand.nextInt(possibleTypes.size()));
            }
        }

        public VertexConsumer getBuilder(MultiBufferSource buffer) {
            if (this.type.hasGlint() && ClientConfigs.Tweaks.BOOK_GLINT.get().booleanValue()) {
                VertexConsumer foilBuilder = null;
                if (CompatHandler.ENCHANTEDBOOKREDESIGN) {
                    foilBuilder = EnchantRedesignCompat.getBookColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = new SpriteCoordinateUnExpander(buffer.getBuffer(RenderType.entityGlint()), ModMaterials.BOOK_GLINT_MATERIAL.sprite());
                }
                return foilBuilder;
            }
            return null;
        }

        public float getAngle() {
            return this.yAngle;
        }

        public BookType getType() {
            return this.type;
        }
    }
}

