/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;

public class PlaceableBookManager
extends SimpleJsonResourceReloadListener {
    public static final SidedInstance<PlaceableBookManager> INSTANCES = SidedInstance.of(PlaceableBookManager::new);
    private final MapRegistry<BookType> books = new MapRegistry("placeable_books");
    private final HolderLookup.Provider registryAccess;

    public PlaceableBookManager(HolderLookup.Provider registryAccess) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "placeable_books");
        this.registryAccess = registryAccess;
        INSTANCES.set(registryAccess, (Object)this);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.books.clear();
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registryAccess);
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation id = entry.getKey();
            BookType type = (BookType)((Pair)BookType.makeNamedCodec(id).decode((DynamicOps)ops, (Object)entry.getValue()).getOrThrow()).getFirst();
            this.books.register(entry.getKey(), (Object)type);
        }
    }

    public List<BookType> getForItem(ItemStack stack, boolean horizontal) {
        ArrayList<BookType> results = new ArrayList<BookType>();
        for (BookType entry : this.books.getValues()) {
            if (!entry.predicate().test(stack) || entry.isHorizontal() != horizontal) continue;
            results.add(entry);
        }
        return results;
    }

    public BookType getByName(ResourceLocation id) {
        return (BookType)this.books.getValue(id);
    }
}

