/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.hourglass;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimeData;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncHourglassPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HourglassTimesManager
extends SimpleJsonResourceReloadListener {
    private static final SidedInstance<HourglassTimesManager> INSTANCES = SidedInstance.of(HourglassTimesManager::new);
    private final Map<Item, HourglassTimeData> dustsMap = new Object2ObjectOpenHashMap();
    private final Set<HourglassTimeData> dusts = new HashSet<HourglassTimeData>();
    private final HolderLookup.Provider registryAccess;

    public static HourglassTimesManager getInstance(HolderLookup.Provider ra) {
        return (HourglassTimesManager)((Object)INSTANCES.get(ra));
    }

    public static HourglassTimesManager getInstance(@NotNull Level level) {
        Preconditions.checkNotNull((Object)level);
        return HourglassTimesManager.getInstance((HolderLookup.Provider)level.registryAccess());
    }

    public HourglassTimesManager(HolderLookup.Provider registryAccess) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "hourglass_dusts");
        this.registryAccess = registryAccess;
        INSTANCES.set(registryAccess, (Object)this);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.dustsMap.clear();
        ArrayList<HourglassTimeData> list = new ArrayList<HourglassTimeData>();
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registryAccess);
        jsonMap.forEach((key, json) -> {
            try {
                DataResult result = HourglassTimeData.CODEC.parse((DynamicOps)ops, json);
                HourglassTimeData data = (HourglassTimeData)result.getOrThrow();
                list.add(data);
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for hourglass data {}", key, (Object)e);
            }
        });
        this.setData(list);
    }

    public void setData(List<HourglassTimeData> list) {
        this.dusts.clear();
        this.dusts.addAll(list);
    }

    public HourglassTimeData getData(Item item) {
        if (this.dustsMap.isEmpty()) {
            ArrayList<HourglassTimeData> list = new ArrayList<HourglassTimeData>(this.dusts);
            list.sort(Comparator.comparing(HourglassTimeData::ordering));
            for (HourglassTimeData data : Lists.reverse(list)) {
                this.dusts.add(data);
                data.getItems().forEach(i -> {
                    if (i.value() == Items.AIR) {
                        Supplementaries.error();
                    } else {
                        this.dustsMap.put((Item)i.value(), data);
                    }
                });
            }
        }
        return this.dustsMap.getOrDefault(item, HourglassTimeData.EMPTY);
    }

    public static void sendDataToClient(ServerPlayer player) {
        HourglassTimesManager instance = HourglassTimesManager.getInstance(player.level());
        NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBoundSyncHourglassPacket(instance.dusts));
    }
}

