/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.fire_behaviors;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.IEntityInterceptFakeLevel;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GenericProjectileBehavior
implements IBallisticBehavior {
    private static final GameProfile FAKE_PLAYER = new GameProfile(UUID.fromString("11242C44-14d5-1f22-3d27-13D2C45CA355"), "[CANNON_TESTER]");

    @Override
    public IBallisticBehavior.Data calculateData(ItemStack projectile, Level level) {
        if (projectile.isEmpty()) {
            return IBallisticBehavior.LINE;
        }
        Entity proj = this.createEntity(projectile, (IEntityInterceptFakeLevel)IEntityInterceptFakeLevel.get(level), new Vec3(1.0, 0.0, 0.0));
        if (proj != null) {
            double speed = proj.getDeltaMovement().length();
            if (speed == 0.0 && proj instanceof AbstractArrow) {
                speed = 2.0;
            }
            proj.setDeltaMovement(1.0, 0.0, 0.0);
            proj.tick();
            Vec3 newMovement = proj.getDeltaMovement();
            float drag = (float)newMovement.x;
            float gravity = (float)(-newMovement.y);
            return new IBallisticBehavior.Data(drag, gravity, (float)speed);
        }
        return IBallisticBehavior.LINE;
    }

    @Override
    public boolean fireInner(ItemStack stack, ServerLevel level, Vec3 firePos, Vec3 facing, float scalePower, int inaccuracy, @Nullable Player owner) {
        Entity entity = this.createEntity(stack, (IEntityInterceptFakeLevel)IEntityInterceptFakeLevel.get((Level)level), facing);
        if (entity != null) {
            CompoundTag c = new CompoundTag();
            entity.save(c);
            Optional opt = EntityType.create((CompoundTag)c, (Level)level);
            if (opt.isPresent()) {
                entity = (Entity)opt.get();
            }
            if (entity instanceof Projectile) {
                Projectile pr = (Projectile)entity;
                pr.cachedOwner = null;
                pr.ownerUUID = null;
                pr.setOwner((Entity)owner);
                pr.shoot(facing.x, facing.y, facing.z, scalePower, (float)inaccuracy);
            }
            entity.setPos(firePos.x, firePos.y, firePos.z);
            level.addFreshEntity(entity);
            return true;
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    public Entity createEntity(ItemStack projectile, IEntityInterceptFakeLevel testLevel, Vec3 facing) {
        Level fakeLevel = testLevel.cast();
        Player fakePlayer = FakePlayerManager.get((GameProfile)FAKE_PLAYER, (Level)fakeLevel);
        fakePlayer.setXRot((float)MthUtils.getPitch((Vec3)facing));
        fakePlayer.setYRot((float)MthUtils.getYaw((Vec3)facing));
        testLevel.setup();
        Item item = projectile.getItem();
        if (item instanceof ArrowItem) {
            ArrowItem ai = (ArrowItem)item;
            return ai.createArrow(fakeLevel, projectile, (LivingEntity)fakePlayer, null);
        }
        item = projectile.getItem();
        if (item instanceof ProjectileItem) {
            ProjectileItem ti = (ProjectileItem)item;
            ProjectileItem.DispenseConfig config = ti.createDispenseConfig();
            Projectile p = ti.asProjectile(fakeLevel, (Position)Vec3.ZERO, projectile, Direction.UP);
            float power = config.power();
            if (p instanceof ThrownPotion) {
                power *= 0.75f;
            }
            p.shoot(0.0, 1.0, 0.0, power, config.uncertainty());
            return p;
        }
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, projectile.copy());
        InteractionResultHolder<ItemStack> eventResult = SuppPlatformStuff.fireItemUseEvent(fakePlayer, InteractionHand.MAIN_HAND);
        if (!eventResult.getResult().consumesAction()) {
            projectile.use(fakeLevel, fakePlayer, InteractionHand.MAIN_HAND);
        }
        return testLevel.getIntercepted();
    }
}

