/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FarmersDelightCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StickBlock
extends WaterBlock
implements IRotatable {
    protected static final VoxelShape Y_AXIS_AABB = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape Y_Z_AXIS_AABB = Shapes.or((VoxelShape)Y_AXIS_AABB, (VoxelShape)Z_AXIS_AABB);
    protected static final VoxelShape Y_X_AXIS_AABB = Shapes.or((VoxelShape)Y_AXIS_AABB, (VoxelShape)X_AXIS_AABB);
    protected static final VoxelShape X_Z_AXIS_AABB = Shapes.or((VoxelShape)X_AXIS_AABB, (VoxelShape)Z_AXIS_AABB);
    protected static final VoxelShape X_Y_Z_AXIS_AABB = Shapes.or((VoxelShape)X_AXIS_AABB, (VoxelShape[])new VoxelShape[]{Y_AXIS_AABB, Z_AXIS_AABB});
    public static final BooleanProperty AXIS_X = ModBlockProperties.AXIS_X;
    public static final BooleanProperty AXIS_Y = ModBlockProperties.AXIS_Y;
    public static final BooleanProperty AXIS_Z = ModBlockProperties.AXIS_Z;
    public static final Map<Direction.Axis, BooleanProperty> AXIS2PROPERTY = Map.of(Direction.Axis.X, AXIS_X, Direction.Axis.Y, AXIS_Y, Direction.Axis.Z, AXIS_Z);

    public StickBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(true))).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS_X, AXIS_Y, AXIS_Z});
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        boolean x = (Boolean)state.getValue((Property)AXIS_X);
        boolean y = (Boolean)state.getValue((Property)AXIS_Y);
        boolean z = (Boolean)state.getValue((Property)AXIS_Z);
        return StickBlock.getStickShape(x, y, z);
    }

    public static VoxelShape getStickShape(boolean x, boolean y, boolean z) {
        if (x) {
            if (y) {
                if (z) {
                    return X_Y_Z_AXIS_AABB;
                }
                return Y_X_AXIS_AABB;
            }
            if (z) {
                return X_Z_AXIS_AABB;
            }
            return X_AXIS_AABB;
        }
        if (z) {
            if (y) {
                return Y_Z_AXIS_AABB;
            }
            return Z_AXIS_AABB;
        }
        return Y_AXIS_AABB;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        BooleanProperty axis = AXIS2PROPERTY.get(context.getClickedFace().getAxis());
        if (blockstate.is((Block)this) || CompatHandler.FARMERS_DELIGHT && FarmersDelightCompat.canAddStickToTomato(blockstate, axis)) {
            return (BlockState)blockstate.setValue((Property)axis, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).setValue((Property)axis, (Comparable)Boolean.valueOf(true));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        BooleanProperty axis;
        if (!context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && !((Boolean)state.getValue((Property)(axis = AXIS2PROPERTY.get(context.getClickedFace().getAxis())))).booleanValue()) {
            return true;
        }
        return super.canBeReplaced(state, context);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return super.isPathfindable(state, pathComputationType);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.isEmpty() && hand == InteractionHand.MAIN_HAND && CommonConfigs.Building.FLAG_POLE.get().booleanValue()) {
            if (this != ModRegistry.STICK_BLOCK.get()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            Direction moveDir = player.isShiftKeyDown() ? Direction.DOWN : Direction.UP;
            StickBlock.findConnectedFlag(level, pos, Direction.UP, moveDir, 0);
            StickBlock.findConnectedFlag(level, pos, Direction.DOWN, moveDir, 0);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static boolean isVertical(BlockState state) {
        return (Boolean)state.getValue((Property)AXIS_Y) != false && (Boolean)state.getValue((Property)AXIS_X) == false && (Boolean)state.getValue((Property)AXIS_Z) == false;
    }

    public static boolean findConnectedFlag(Level level, BlockPos pos, Direction searchDir, Direction moveDir, int it) {
        if (it > CommonConfigs.Building.FLAG_POLE_LENGTH.get()) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        Block b = state.getBlock();
        if (b == ModRegistry.STICK_BLOCK.get() && StickBlock.isVertical(state)) {
            return StickBlock.findConnectedFlag(level, pos.relative(searchDir), searchDir, moveDir, it + 1);
        }
        if (b instanceof FlagBlock && it != 0) {
            BlockPos toPos = pos.relative(moveDir);
            BlockState stick = level.getBlockState(toPos);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FlagBlockTile) {
                FlagBlockTile tile = (FlagBlockTile)blockEntity;
                if (stick.getBlock() == ModRegistry.STICK_BLOCK.get() && StickBlock.isVertical(stick)) {
                    level.setBlockAndUpdate(pos, stick);
                    level.setBlockAndUpdate(toPos, state);
                    CompoundTag tag = tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                    BlockEntity te = level.getBlockEntity(toPos);
                    if (te != null) {
                        te.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
                    }
                    level.playSound(null, toPos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 1.0f, 1.4f);
                    return true;
                }
            }
        }
        return false;
    }

    public BlockState applyRotationLock(Level level, BlockPos blockPos, BlockState state, Direction dir, int half) {
        int i = 0;
        if (((Boolean)state.getValue((Property)AXIS_X)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.getValue((Property)AXIS_Z)).booleanValue()) {
            ++i;
        }
        if (i == 1) {
            ((BlockState)((BlockState)((BlockState)state.setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS2PROPERTY.get(dir.getAxis()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockState newState;
        if (rotation == Rotation.CLOCKWISE_180) {
            return Optional.empty();
        }
        boolean x = (Boolean)state.getValue((Property)AXIS_X);
        boolean y = (Boolean)state.getValue((Property)AXIS_Y);
        boolean z = (Boolean)state.getValue((Property)AXIS_Z);
        switch (axis.getAxis()) {
            default: {
                throw new MatchException(null, null);
            }
            case Y: {
                BlockState blockState = (BlockState)((BlockState)state.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(z))).setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(x));
                break;
            }
            case X: {
                BlockState blockState = (BlockState)((BlockState)state.setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(z))).setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(y));
                break;
            }
            case Z: {
                BlockState blockState = newState = (BlockState)((BlockState)state.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(y))).setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(x));
            }
        }
        if (newState != state) {
            return Optional.of(newState);
        }
        return Optional.empty();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return this.getRotatedState(state, null, null, rotation, Direction.UP, null).orElse(state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder pBuilder) {
        int i = 0;
        if (((Boolean)state.getValue((Property)AXIS_X)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.getValue((Property)AXIS_Z)).booleanValue()) {
            ++i;
        }
        return List.of(new ItemStack((ItemLike)this.asItem(), i));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelIn, BlockPos currentPos, BlockPos facingPos) {
        if (this == ModRegistry.STICK_BLOCK.get()) {
            // empty if block
        }
        return super.updateShape(stateIn, facing, facingState, levelIn, currentPos, facingPos);
    }
}

