/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BuntingBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RopeBuntingBlock
extends AbstractRopeBlock
implements EntityBlock,
IRotatable,
IWashable {
    public static final EnumProperty<ModBlockProperties.Bunting> NORTH = ModBlockProperties.NORTH_BUNTING;
    public static final EnumProperty<ModBlockProperties.Bunting> SOUTH = ModBlockProperties.SOUTH_BUNTING;
    public static final EnumProperty<ModBlockProperties.Bunting> WEST = ModBlockProperties.WEST_BUNTING;
    public static final EnumProperty<ModBlockProperties.Bunting> EAST = ModBlockProperties.EAST_BUNTING;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, EnumProperty<ModBlockProperties.Bunting>> HORIZONTAL_FACING_TO_PROPERTY_MAP = (Map)Util.make((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
    });
    public final Map<BlockState, BlockState> buntingToRope = new Object2ObjectOpenHashMap();

    public RopeBuntingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        UnmodifiableIterator unmodifiableIterator = this.stateDefinition.getPossibleStates().iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            BlockState state1 = state = (BlockState)unmodifiableIterator.next();
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                state1 = this.setConnection(dir, state1, this.hasConnection(dir, state1));
            }
            this.buntingToRope.put(state, state1);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Override
    protected Map<BlockState, VoxelShape> makeShapes() {
        HashMap<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
        VoxelShape down = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.box((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape south = Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        VoxelShape west = Block.box((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape east = Block.box((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        VoxelShape knot = Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape northBunting = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)10.0, (double)8.0);
        VoxelShape southBunting = Block.box((double)7.0, (double)0.0, (double)8.0, (double)9.0, (double)10.0, (double)16.0);
        VoxelShape westBunting = Block.box((double)0.0, (double)0.0, (double)7.0, (double)8.0, (double)10.0, (double)9.0);
        VoxelShape eastBunting = Block.box((double)8.0, (double)0.0, (double)7.0, (double)16.0, (double)10.0, (double)9.0);
        for (BlockState state : this.stateDefinition.getPossibleStates()) {
            ModBlockProperties.Bunting e;
            ModBlockProperties.Bunting w;
            ModBlockProperties.Bunting s;
            ModBlockProperties.Bunting n;
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) continue;
            VoxelShape v = Shapes.empty();
            if (((Boolean)state.getValue((Property)KNOT)).booleanValue()) {
                v = Shapes.or((VoxelShape)knot, (VoxelShape[])new VoxelShape[0]);
            }
            if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)up);
            }
            if ((n = (ModBlockProperties.Bunting)((Object)state.getValue(NORTH))).isConnected()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)north);
            }
            if (n.hasBunting()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)northBunting);
            }
            if ((s = (ModBlockProperties.Bunting)((Object)state.getValue(SOUTH))).isConnected()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)south);
            }
            if (s.hasBunting()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)southBunting);
            }
            if ((w = (ModBlockProperties.Bunting)((Object)state.getValue(WEST))).isConnected()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)west);
            }
            if (w.hasBunting()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)westBunting);
            }
            if ((e = (ModBlockProperties.Bunting)((Object)state.getValue(EAST))).isConnected()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)east);
            }
            if (e.hasBunting()) {
                v = Shapes.or((VoxelShape)v, (VoxelShape)eastBunting);
            }
            v = v.optimize();
            boolean flag = true;
            for (VoxelShape existing : shapes.values()) {
                if (!existing.equals(v)) continue;
                shapes.put(state, existing);
                flag = false;
                break;
            }
            if (!flag) continue;
            shapes.put(state, v);
        }
        return new Object2ObjectOpenHashMap(shapes);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public boolean hasConnection(Direction dir, BlockState state) {
        if (dir == Direction.DOWN) {
            return (Boolean)state.getValue((Property)DOWN);
        }
        if (dir == Direction.UP) {
            return (Boolean)state.getValue((Property)UP);
        }
        return ((ModBlockProperties.Bunting)((Object)state.getValue((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir)))).isConnected();
    }

    @Override
    public BlockState setConnection(Direction dir, BlockState state, boolean value) {
        if (dir == Direction.DOWN) {
            return (BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(value));
        }
        if (dir == Direction.UP) {
            return (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(value));
        }
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir), (Comparable)((Object)(value ? ModBlockProperties.Bunting.ROPE : ModBlockProperties.Bunting.NONE)));
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.of(state);
    }

    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity;
        if (axis.getAxis() == Direction.Axis.Y && (blockEntity = level.getBlockEntity(pos)) instanceof BuntingBlockTile) {
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            HashMap<Direction, ItemStack> newMap = new HashMap<Direction, ItemStack>();
            for (Direction dir2 : Direction.Plane.HORIZONTAL) {
                ItemStack stack2 = tile.getItem(dir2.get2DDataValue());
                if (stack2.isEmpty()) continue;
                Direction newDir = rotation.rotate(dir2);
                if (RopeBuntingBlock.canSupportBunting(state, newDir.get2DDataValue())) {
                    newMap.put(newDir, stack2);
                    continue;
                }
                return Optional.empty();
            }
            if (!newMap.isEmpty()) {
                tile.clearContent();
                newMap.forEach((dir, stack) -> tile.setItem(dir.get2DDataValue(), (ItemStack)stack));
                return Optional.of(axis);
            }
        }
        return Optional.empty();
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return super.getCollisionShape(this.buntingToRope.get(state), worldIn, pos, context);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BuntingBlockTile(pos, state);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BuntingBlockTile) {
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            Optional<Direction> closest = RopeBuntingBlock.findClosestConnection(state, pos, hit.getLocation());
            if (closest.isPresent()) {
                return tile.interactWithPlayerItem(player, hand, stack, closest.get().get2DDataValue());
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        Optional<Direction> closest = RopeBuntingBlock.findClosestConnection(state, pos, target.getLocation());
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BuntingBlockTile) {
            ItemStack held;
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            if (closest.isPresent() && !(held = tile.getItem(closest.get().get2DDataValue())).isEmpty()) {
                return held.copy();
            }
        }
        return this.getCloneItemStack(world, pos, state);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ModRegistry.ROPE_ITEM.get().getDefaultInstance();
    }

    private static Optional<Direction> findClosestConnection(BlockState state, BlockPos pos, Vec3 hit) {
        Vector3f hitPos = hit.subtract((double)pos.getX() + 0.5, 0.0, (double)pos.getZ() + 0.5).toVector3f();
        List<Direction> availableDir = Direction.Plane.HORIZONTAL.stream().filter(dir -> ((AbstractRopeBlock)state.getBlock()).hasConnection((Direction)dir, state)).toList();
        return availableDir.stream().min((a, b) -> {
            Vector3f v1 = a.step();
            Vector3f v2 = b.step();
            float d1 = v1.distanceSquared((Vector3fc)hitPos);
            float d2 = v2.distanceSquared((Vector3fc)hitPos);
            return Float.compare(d1, d2);
        });
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockEntity blockEntity;
        BlockState newState = super.updateShape(stateIn, facing, facingState, level, pos, facingPos);
        if (facing.getAxis().isHorizontal() && this.hasConnection(facing, stateIn) && (blockEntity = level.getBlockEntity(pos)) instanceof BuntingBlockTile) {
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            int index = facing.get2DDataValue();
            ItemStack item = tile.getItem(index);
            if (!item.isEmpty()) {
                if (!RopeBuntingBlock.canSupportBunting(newState, index)) {
                    if (level instanceof Level) {
                        Level l = (Level)level;
                        this.popItem(l, pos, item, facing);
                    }
                    tile.setItem(index, ItemStack.EMPTY);
                    newState = (BlockState)newState.setValue((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(facing), (Comparable)((Object)ModBlockProperties.Bunting.NONE));
                } else {
                    newState = (BlockState)newState.setValue((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(facing), (Comparable)((Object)ModBlockProperties.Bunting.BUNTING));
                }
            }
            if (tile.isEmpty()) {
                newState = RopeBuntingBlock.toRope(newState);
            }
        }
        return newState;
    }

    public void popItem(Level level, BlockPos pos, ItemStack stack, Direction dir) {
        if (!level.isClientSide && !stack.isEmpty() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            double h = (double)EntityType.ITEM.getHeight() / 2.0 + 0.25;
            Vector3f step = dir.step().mul(0.25f);
            double x = (double)(step.x + (float)pos.getX()) + 0.5;
            double y = (double)(step.y + (float)pos.getY()) + 0.5 - h;
            double z = (double)(step.z + (float)pos.getZ()) + 0.5;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack.copy());
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    public static boolean canSupportBunting(BlockState state, int index) {
        Direction dir = Direction.from2DDataValue((int)index);
        return ((ModBlockProperties.Bunting)((Object)state.getValue((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir)))).isConnected();
    }

    @Nullable
    public static BlockState fromRope(BlockState state, BlockHitResult hit) {
        BlockState s = RopeBuntingBlock.fromRope(state);
        Optional<Direction> closest = RopeBuntingBlock.findClosestConnection(state, hit.getBlockPos(), hit.getLocation());
        return closest.map(direction -> (BlockState)s.setValue((Property)HORIZONTAL_FACING_TO_PROPERTY_MAP.get(direction), (Comparable)((Object)ModBlockProperties.Bunting.BUNTING))).orElse(null);
    }

    public static BlockState fromRope(BlockState state) {
        RopeBuntingBlock block = ModRegistry.BUNTING_BLOCK.get();
        BlockState s = block.withPropertiesOf(state);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            s = block.setConnection(dir, s, ((RopeBlock)state.getBlock()).hasConnection(dir, state));
        }
        return s;
    }

    public static BlockState toRope(BlockState state) {
        RopeBlock block = ModRegistry.ROPE.get();
        BlockState s = block.withPropertiesOf(state);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            s = block.setConnection(dir, s, ((RopeBuntingBlock)state.getBlock()).hasConnection(dir, state));
        }
        return s;
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        Optional<Direction> closest = RopeBuntingBlock.findClosestConnection(state, pos, hitVec);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BuntingBlockTile) {
            ItemStack held;
            BuntingBlockTile tile = (BuntingBlockTile)blockEntity;
            if (closest.isPresent() && !(held = tile.getItem(closest.get().get2DDataValue())).isEmpty() && BuntingItem.getColor(held) != DyeColor.WHITE) {
                BuntingItem.setColor(held, DyeColor.WHITE);
                tile.setItem(closest.get().get2DDataValue(), held);
                tile.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
                return true;
            }
        }
        return false;
    }
}

