/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GobletBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GobletBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_15;

    public GobletBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Integer)state.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        GobletBlockTile tile;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GobletBlockTile && (tile = (GobletBlockTile)blockEntity).getSoftFluidTank().interactWithPlayer(player, hand, level, pos)) {
            if (!level.isClientSide()) {
                tile.setChanged();
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GobletBlockTile) {
            GobletBlockTile tile = (GobletBlockTile)blockEntity;
            if (!player.isShiftKeyDown() && CommonConfigs.Building.GOBLET_DRINK.get().booleanValue()) {
                boolean success = tile.getSoftFluidTank().tryDrinkUpFluid(player, level);
                if (success && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Utils.awardAdvancement((ServerPlayer)serverPlayer, (ResourceLocation)Supplementaries.res("nether/goblet"));
                }
                if (success) {
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIGHT_LEVEL});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new GobletBlockTile(pPos, pState);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GobletBlockTile) {
            GobletBlockTile tile = (GobletBlockTile)blockEntity;
            return tile.fluidHolder.isEmpty() ? 0 : 15;
        }
        return 0;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        GobletBlockTile tile;
        SoftFluidTank tank;
        BlockEntity blockEntity;
        if (0.05 > (double)random.nextFloat() && (blockEntity = world.getBlockEntity(pos)) instanceof GobletBlockTile && (tank = (tile = (GobletBlockTile)blockEntity).getSoftFluidTank()).getFluid().is(MLBuiltinSoftFluids.POTION)) {
            int color = tank.getCachedStillColor((BlockAndTintGetter)world, pos);
            world.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), (double)pos.getX() + 0.3125 + (double)random.nextFloat() * 0.375, (double)pos.getY() + 0.5625, (double)pos.getZ() + 0.3125 + (double)random.nextFloat() * 0.375, 0.0, 0.0, 0.0);
        }
    }
}

