/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.AlternativeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SlingshotBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class CannonBlock
extends DirectionalBlock
implements EntityBlock,
ILightable,
IRotatable {
    public static final MapCodec<CannonBlock> CODEC = CannonBlock.simpleCodec(CannonBlock::new);
    private static final Map<Item, IFireItemBehavior> FIRE_BEHAVIORS = new Object2ObjectOpenHashMap();
    private static final IFireItemBehavior DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SlingshotBehavior());
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public CannonBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public static void registerBehavior(ItemLike pItem, IFireItemBehavior pBehavior) {
        FIRE_BEHAVIORS.put(pItem.asItem(), pBehavior);
    }

    public static IFireItemBehavior getCannonBehavior(ItemLike item) {
        return FIRE_BEHAVIORS.getOrDefault(item, DEFAULT);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            return tile;
        }
        return null;
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, POWERED});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer != null && (blockEntity = level.getBlockEntity(pos)) instanceof CannonBlockTile) {
            CannonBlockTile cannon = (CannonBlockTile)blockEntity;
            Direction dir = Direction.orderedByNearest((Entity)placer)[0];
            Direction myDir = ((Direction)state.getValue((Property)FACING)).getOpposite();
            if (dir.getAxis() == Direction.Axis.Y) {
                float pitch = dir == Direction.UP ? -90.0f : 90.0f;
                cannon.setRestrainedPitch(myDir.getOpposite() == dir ? pitch + 180.0f : pitch);
            } else {
                float yaw = dir.toYRot();
                cannon.setRestrainedYaw(myDir.getOpposite() == dir ? yaw + 180.0f : yaw);
            }
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean wasPowered;
        if (!level.isClientSide && (wasPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            BlockEntity blockEntity;
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            if (!wasPowered && (blockEntity = level.getBlockEntity(pos)) instanceof CannonBlockTile) {
                CannonBlockTile tile = (CannonBlockTile)blockEntity;
                tile.ignite(null);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CannonBlockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.CANNON_TILE.get(), CannonBlockTile::tick);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult r = this.lightableInteractWithPlayerItem(state, level, pos, player, hand, stack);
        if (r.consumesAction()) {
            return r;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                tile.tryOpeningEditGui(sp, pos, stack);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            return tile.isFiring();
        }
        return false;
    }

    public boolean tryLightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSoundType fireSourceType) {
        CannonBlockTile tile;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile && !(tile = (CannonBlockTile)blockEntity).readyToFire()) {
            return false;
        }
        return super.tryLightUp(player, state, pos, world, fireSourceType);
    }

    public void setLitUp(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, @Nullable Entity igniter, boolean on) {
        BlockEntity blockEntity = levelAccessor.getBlockEntity(blockPos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            tile.ignite(igniter);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return switch (((Direction)state.getValue((Property)FACING)).getOpposite()) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return super.getShape(state, level, pos, context);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ec = (EntityCollisionContext)context;
            Entity entity = ec.getEntity();
            if (entity instanceof Projectile) {
                Projectile p = (Projectile)entity;
                if (p.tickCount < 10) {
                    return Shapes.empty();
                }
            }
            if (ec.getEntity() != null) {
                return super.getCollisionShape(state, level, pos, context);
            }
        }
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id > 1) {
            return false;
        }
        if (!level.isClientSide) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            float yaw = tile.getYaw();
            float pitch = tile.getPitch();
            PoseStack poseStack = new PoseStack();
            poseStack.translate((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f + 0.0625f, (float)pos.getZ() + 0.5f);
            if (tile.isBig()) {
                poseStack.scale(3.0f, 3.0f, 3.0f);
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(-yaw));
            poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
            poseStack.translate(0.0, 0.0, -1.4);
            if (id == 1) {
                this.playFiringEffects(pos, level, poseStack, pitch, yaw, tile.getPowerLevel(), tile.isBig());
            } else {
                CannonBlock.playIgniteEffects(pos, level, poseStack);
            }
        }
        return false;
    }

    private static void playIgniteEffects(BlockPos pos, Level level, PoseStack poseStack) {
        Vector4f p = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, 1.75f, 1.0f));
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)p.x, (double)p.y, (double)p.z, 0.0, 0.0, 0.0);
        level.playLocalSound(pos, ModSounds.CANNON_IGNITE.get(), SoundSource.BLOCKS, 0.6f, 1.2f + level.getRandom().nextFloat() * 0.2f, false);
    }

    private void playFiringEffects(BlockPos pos, Level level, PoseStack poseStack, float pitch, float yaw, int power, boolean isBig) {
        level.addParticle((ParticleOptions)ModParticles.CANNON_FIRE_PARTICLE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(pitch * ((float)Math.PI / 180)), (double)(-yaw * ((float)Math.PI / 180)), isBig ? 3.0 : 1.0);
        RandomSource ran = level.random;
        this.spawnDustRing(level, poseStack, isBig);
        this.spawnSmokeTrail(level, poseStack, ran, isBig);
        float soundPitch = 1.3f - (float)power * 0.1f;
        if (isBig) {
            soundPitch -= 0.2f;
        }
        float soundVolume = 2.0f + (float)power * 0.6f;
        if (isBig) {
            soundVolume += 0.5f;
        }
        level.playLocalSound(pos, ModSounds.CANNON_FIRE.get(), SoundSource.BLOCKS, soundVolume, soundPitch, false);
    }

    private void spawnSmokeTrail(Level level, PoseStack poseStack, RandomSource ran, boolean isBig) {
        int smokeCount = 40;
        if (isBig) {
            smokeCount *= 3;
        }
        for (int i = 0; i < smokeCount; ++i) {
            poseStack.pushPose();
            Vector4f speed = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, -MthUtils.nextWeighted((RandomSource)ran, (float)0.5f, (float)1.0f, (float)0.06f), 0.0f));
            float aperture = 0.5f;
            if (isBig) {
                aperture *= 3.0f;
            }
            poseStack.translate(-aperture / 2.0f + ran.nextFloat() * aperture, -aperture / 2.0f + ran.nextFloat() * aperture, 0.0f);
            Vector4f p = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.popPose();
        }
    }

    private void spawnDustRing(Level level, PoseStack poseStack, boolean isBig) {
        poseStack.pushPose();
        Vector4f p = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        int dustCount = 16;
        if (isBig) {
            dustCount *= 3;
        }
        for (int i = 0; i < dustCount; ++i) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(380.0f * (float)i / (float)dustCount));
            float vel = 0.05f;
            if (isBig) {
                vel /= 1.5f;
            }
            Vector4f speed = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, vel, 0.0f));
            SimpleParticleType campfireCosySmoke = isBig ? ParticleTypes.CAMPFIRE_COSY_SMOKE : ModParticles.BOMB_SMOKE_PARTICLE.get();
            level.addParticle((ParticleOptions)campfireCosySmoke, (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor levelAccessor, BlockPos blockPos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        boolean ccw = rotation == Rotation.COUNTERCLOCKWISE_90;
        return BlockUtil.getRotatedDirectionalBlock(state, axis, ccw).or(() -> Optional.of(state));
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity;
        if (axis.getAxis() == ((Direction)newState.getValue((Property)FACING)).getAxis() && (blockEntity = world.getBlockEntity(pos)) instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            float angle = rotation.rotate(0, 4) * -90;
            Vector3f currentDir = Vec3.directionFromRotation((float)tile.getPitch(), (float)tile.getYaw()).toVector3f();
            Quaternionf q = new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)axis.step());
            currentDir.rotate((Quaternionfc)q);
            Vec3 newDir = new Vec3(currentDir);
            tile.setRestrainedYaw((float)MthUtils.getYaw((Vec3)newDir));
            tile.setRestrainedPitch((float)MthUtils.getPitch((Vec3)newDir));
            tile.setChanged();
            tile.getLevel().sendBlockUpdated(pos, oldState, newState, 3);
        }
    }
}

