/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BubbleBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BubbleBlock
extends Block
implements EntityBlock {
    public BubbleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext placeContext) {
        return !placeContext.isSecondaryUseActive();
    }

    public boolean isPossibleToRespawnInThis(BlockState blockState) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return Shapes.block();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ec;
        if (collisionContext.isAbove(Shapes.block(), pos, false) && collisionContext instanceof EntityCollisionContext && (ec = (EntityCollisionContext)collisionContext).getEntity() instanceof LivingEntity) {
            return Shapes.block();
        }
        return Shapes.empty();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (CommonConfigs.Tools.BUBBLE_BREAK.get().booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BubbleBlock.breakBubble((Level)serverLevel, pos, state);
        }
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        this.makeParticle(pos, level);
        BubbleBlock.playBreakSound(state, level, pos, player);
    }

    private static void playBreakSound(BlockState state, Level level, BlockPos pos, Player player) {
        SoundType soundtype = state.getSoundType();
        level.playSound(player, pos, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public void makeParticle(BlockPos pos, Level level) {
        level.addParticle((ParticleOptions)ModParticles.BUBBLE_BLOCK_PARTICLE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
    }

    public static void sendParticles(BlockPos pos, ServerLevel level) {
        level.sendParticles((ParticleOptions)ModParticles.BUBBLE_BLOCK_PARTICLE.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void breakBubble(Level level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            level.removeBlock(pos, false);
            BubbleBlock.sendParticles(pos, sl);
            BubbleBlock.playBreakSound(state, level, pos, null);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (this.canPopBubble(entity)) {
            level.scheduleTick(pos, (Block)this, 5);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float v) {
        super.fallOn(level, state, pos, entity, v);
        if (!level.isClientSide && CommonConfigs.Tools.BUBBLE_BREAK.get().booleanValue() && this.canPopBubble(entity)) {
            if (v > 3.0f) {
                BubbleBlock.breakBubble(level, pos, state);
            } else {
                level.scheduleTick(pos, (Block)this, (int)Mth.clamp((float)(7.0f - v / 2.0f), (float)1.0f, (float)5.0f));
            }
        }
    }

    protected boolean canPopBubble(Entity entity) {
        if (!CommonConfigs.Tools.BUBBLE_BREAK.get().booleanValue()) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return !EnchantmentHelper.hasTag((ItemStack)le.getItemBySlot(EquipmentSlot.FEET), ModTags.PREVENTS_BUBBLE_POP);
        }
        return true;
    }

    public void tick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        BubbleBlock.breakBubble((Level)serverLevel, pos, state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BubbleBlockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> tBlockEntityType) {
        return Utils.getTicker(tBlockEntityType, ModRegistry.BUBBLE_BLOCK_TILE.get(), BubbleBlockTile::tick);
    }
}

