/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BookPileHorizontalBlock
extends BookPileBlock {
    private static final VoxelShape SHAPE_1_Z = Block.box((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_1_X = Block.box((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_2_Z = Block.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_2_X = Block.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)10.0, (double)13.0);
    private static final VoxelShape SHAPE_3_Z = Block.box((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_3_X = Block.box((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)10.0, (double)15.0);
    private static final VoxelShape SHAPE_4_Z = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_4_X = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BookPileHorizontalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BOOKS, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.getBlock() instanceof BookPileBlock) {
            return (BlockState)blockstate.setValue((Property)BOOKS, (Comparable)Integer.valueOf((Integer)blockstate.getValue((Property)BOOKS) + 1));
        }
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidState.getType() == Fluids.WATER && fluidState.getAmount() == 8;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BookPileBlockTile(pPos, pState, true);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean x = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X;
        return BookPileHorizontalBlock.getVoxelShape(state, x);
    }

    private static VoxelShape getVoxelShape(BlockState state, boolean x) {
        return switch ((Integer)state.getValue((Property)BOOKS)) {
            case 2 -> {
                if (x) {
                    yield SHAPE_2_X;
                }
                yield SHAPE_2_Z;
            }
            case 3 -> {
                if (x) {
                    yield SHAPE_3_X;
                }
                yield SHAPE_3_Z;
            }
            case 4 -> {
                if (x) {
                    yield SHAPE_4_X;
                }
                yield SHAPE_4_Z;
            }
            default -> x ? SHAPE_1_X : SHAPE_1_Z;
        };
    }

    @Override
    protected int getBookIndex(BlockState state, BlockPos pos, Vec3 location) {
        double dist;
        Direction dir = (Direction)state.getValue((Property)FACING);
        double d = dist = dir.getAxis() == Direction.Axis.Z ? location.x - (double)pos.getX() : location.z - (double)pos.getZ();
        if (dir == Direction.NORTH || dir == Direction.EAST) {
            dist = 1.0 - dist;
        }
        double f = (dist -= (1.0 - BookPileHorizontalBlock.getVoxelShape(state, false).bounds().getXsize()) / 2.0) / 0.25;
        return Mth.clamp((int)((int)f), (int)0, (int)((Integer)state.getValue((Property)BOOKS) - 1));
    }
}

