/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BookPileBlock
extends WaterBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_1 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    private static final VoxelShape SHAPE_2 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE_3 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    private static final VoxelShape SHAPE_4 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final IntegerProperty BOOKS = ModBlockProperties.BOOKS;

    public BookPileBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BOOKS, (Comparable)Integer.valueOf(1)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            ItemStack copy = stack.copy();
            copy.setCount(1);
            tile.setItem((Integer)state.getValue((Property)BOOKS) - 1, copy);
        }
    }

    public boolean isAcceptedItem(Item i) {
        AdditionalItemPlacement additionalItemPlacement = ((IExtendedItem)i).moonlight$getAdditionalBehavior();
        if (additionalItemPlacement instanceof SuppAdditionalPlacement) {
            SuppAdditionalPlacement sp = (SuppAdditionalPlacement)additionalItemPlacement;
            Block b = sp.getPlacedBlock();
            if (CommonConfigs.Tweaks.MIXED_BOOKS.get().booleanValue()) {
                return b == ModRegistry.BOOK_PILE.get() || b == ModRegistry.BOOK_PILE_H.get();
            }
            return b == this;
        }
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        Item item;
        if ((Integer)state.getValue((Property)BOOKS) < 4 && this.isAcceptedItem(item = context.getItemInHand().getItem())) {
            return true;
        }
        return super.canBeReplaced(state, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BOOKS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.getBlock() instanceof BookPileBlock) {
            return (BlockState)blockstate.setValue((Property)BOOKS, (Comparable)Integer.valueOf((Integer)blockstate.getValue((Property)BOOKS) + 1));
        }
        return super.getStateForPlacement(context);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BookPileBlockTile(pPos, pState, false);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            tile.getItem((Integer)state.getValue((Property)BOOKS) - 1);
        }
        return Items.BOOK.getDefaultInstance();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            return tile.getItem(this.getBookIndex(state, pos, target.getLocation()));
        }
        return Items.BOOK.getDefaultInstance();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)BOOKS)) {
            default -> SHAPE_1;
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            case 4 -> SHAPE_4;
        };
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            return tile.getEnchantPower();
        }
        return 0.0f;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.isEmpty() && player.isSecondaryUseActive() && (blockEntity = level.getBlockEntity(pos)) instanceof BookPileBlockTile) {
            BookPileBlockTile tile = (BookPileBlockTile)blockEntity;
            return tile.interactWithPlayerItem(player, hand, stack, this.getBookIndex(state, pos, hitResult.getLocation()));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected int getBookIndex(BlockState state, BlockPos pos, Vec3 location) {
        double f = 5.0 * (location.y - (double)pos.getY()) / BookPileBlock.SHAPE_4.bounds().maxY;
        return Mth.clamp((int)((int)f), (int)0, (int)((Integer)state.getValue((Property)BOOKS) - 1));
    }
}

