/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IWaxable {
    public boolean isWaxed();

    public void setWaxed(boolean var1);

    default public ItemInteractionResult tryWaxing(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (stack.getItem() instanceof HoneycombItem) {
            if (this.isWaxed()) {
                level.playSound(null, pos, SoundEvents.WAXED_SIGN_INTERACT_FAIL, SoundSource.BLOCKS);
                return ItemInteractionResult.FAIL;
            }
            level.playSound(null, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS);
            stack.consume(1, (LivingEntity)player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.setWaxed(true);
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                NetworkHelper.sendToAllClientPlayersInParticleRange((ServerLevel)((ServerLevel)level), (BlockPos)pos, (CustomPacketPayload)new ClientBoundParticlePacket(pos, ClientBoundParticlePacket.Kind.WAX_ON));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

